/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.tool.node;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springblade.core.tool.node.INode;

public class ForestNodeManager<T extends INode<T>> {
    private final ImmutableMap<Long, T> nodeMap;
    private final Map<Long, Object> parentIdMap = Maps.newHashMap();

    public ForestNodeManager(List<T> nodes) {
        this.nodeMap = Maps.uniqueIndex(nodes, INode::getId);
    }

    public INode<T> getTreeNodeAt(Long id) {
        if (this.nodeMap.containsKey((Object)id)) {
            return (INode)this.nodeMap.get((Object)id);
        }
        return null;
    }

    public void addParentId(Long parentId) {
        this.parentIdMap.put(parentId, "");
    }

    public List<T> getRoot() {
        ArrayList roots = new ArrayList();
        this.nodeMap.forEach((key, node) -> {
            if (node.getParentId() == 0L || this.parentIdMap.containsKey(node.getId())) {
                roots.add(node);
            }
        });
        return roots;
    }
}

