/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.tool.request;

import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.springblade.core.tool.utils.WebUtil;

public class BladeHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private final HttpServletRequest orgRequest;
    private byte[] body;

    public BladeHttpServletRequestWrapper(HttpServletRequest request) {
        super(request);
        this.orgRequest = request;
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    public ServletInputStream getInputStream() throws IOException {
        if (super.getHeader("Content-Type") == null) {
            return super.getInputStream();
        }
        if (super.getHeader("Content-Type").startsWith("multipart/form-data")) {
            return super.getInputStream();
        }
        if (this.body == null) {
            this.body = WebUtil.getRequestBody(super.getInputStream()).getBytes();
        }
        final ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.body);
        return new ServletInputStream(){

            public int read() {
                return byteArrayInputStream.read();
            }

            public boolean isFinished() {
                return false;
            }

            public boolean isReady() {
                return false;
            }

            public void setReadListener(ReadListener readListener) {
            }
        };
    }

    public HttpServletRequest getOrgRequest() {
        return this.orgRequest;
    }

    public static HttpServletRequest getOrgRequest(HttpServletRequest request) {
        if (request instanceof BladeHttpServletRequestWrapper) {
            return ((BladeHttpServletRequestWrapper)request).getOrgRequest();
        }
        return request;
    }
}

