/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.tool.sensitive;

import java.util.regex.Pattern;

public enum SensitiveType {
    GLOBAL("\u5168\u5c40", "(.{2}).*(.{2})", "$1****$2"),
    MOBILE("\u624b\u673a\u53f7", "(\\d{3})\\d{4}(\\d{4})", "$1****$2"),
    EMAIL("\u7535\u5b50\u90ae\u7bb1", "(\\w{2})\\w+(@\\w+\\.\\w+)", "$1****$2"),
    ID_CARD("\u8eab\u4efd\u8bc1\u53f7", "(\\d{4})\\d{10}(\\w{4})", "$1**********$2"),
    BANK_CARD("\u94f6\u884c\u5361\u53f7", "(\\d{4})\\d+(\\d{4})", "$1****$2"),
    IP_ADDRESS("IP\u5730\u5740", "(\\d{1,3}\\.\\d{1,3})\\.\\d{1,3}\\.\\d{1,3}", "$1.***.***"),
    MAC_ADDRESS("MAC\u5730\u5740", "([0-9A-Fa-f]{2}:[0-9A-Fa-f]{2}):[0-9A-Fa-f]{2}:[0-9A-Fa-f]{2}:[0-9A-Fa-f]{2}:[0-9A-Fa-f]{2}", "$1:****");

    private final String replacement;
    private final Pattern pattern;

    private SensitiveType(String ignore, String regex, String replacement) {
        this.replacement = replacement;
        this.pattern = Pattern.compile(regex);
    }

    public String replaceAll(String content) {
        return this.pattern.matcher(content).replaceAll(this.replacement);
    }
}

