/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.system.cache;

import java.util.List;
import java.util.Optional;
import org.springblade.core.cache.utils.CacheUtil;
import org.springblade.core.tool.api.R;
import org.springblade.core.tool.utils.SpringUtil;
import org.springblade.system.entity.Dict;
import org.springblade.system.enums.DictEnum;
import org.springblade.system.feign.IDictClient;

public class DictCache {
    private static final String DICT_ID = "dict:id:";
    private static final String DICT_KEY = "dict:key:";
    private static final String DICT_VALUE = "dict:value:";
    private static final String DICT_LIST = "dict:list:";
    private static final Boolean TENANT_MODE = Boolean.FALSE;
    private static IDictClient dictClient;

    private static IDictClient getDictClient() {
        if (dictClient == null) {
            dictClient = (IDictClient)SpringUtil.getBean(IDictClient.class);
        }
        return dictClient;
    }

    public static Dict getById(Long id) {
        return (Dict)CacheUtil.get((String)"blade:dict", (String)DICT_ID, (Object)id, () -> {
            R<Dict> result = DictCache.getDictClient().getById(id);
            return (Dict)result.getData();
        }, (Boolean)TENANT_MODE);
    }

    public static String getKey(String code, String dictValue) {
        return (String)CacheUtil.get((String)"blade:dict", (String)(DICT_KEY + code + ":"), (Object)dictValue, () -> {
            List<Dict> list = DictCache.getList(code);
            Optional<String> key = list.stream().filter(dict -> dict.getDictValue().equalsIgnoreCase(dictValue)).map(Dict::getDictKey).findFirst();
            return key.orElse("");
        }, (Boolean)TENANT_MODE);
    }

    public static String getValue(DictEnum code, Integer dictKey) {
        return DictCache.getValue(code.getName(), dictKey);
    }

    public static String getValue(String code, Integer dictKey) {
        return (String)CacheUtil.get((String)"blade:dict", (String)(DICT_VALUE + code + ":"), (Object)String.valueOf(dictKey), () -> {
            R<String> result = DictCache.getDictClient().getValue(code, String.valueOf(dictKey));
            return (String)result.getData();
        }, (Boolean)TENANT_MODE);
    }

    public static String getValue(DictEnum code, String dictKey) {
        return DictCache.getValue(code.getName(), dictKey);
    }

    public static String getValue(String code, String dictKey) {
        return (String)CacheUtil.get((String)"blade:dict", (String)(DICT_VALUE + code + ":"), (Object)dictKey, () -> {
            R<String> result = DictCache.getDictClient().getValue(code, dictKey);
            return (String)result.getData();
        }, (Boolean)TENANT_MODE);
    }

    public static List<Dict> getList(String code) {
        return (List)CacheUtil.get((String)"blade:dict", (String)DICT_LIST, (Object)code, () -> {
            R<List<Dict>> result = DictCache.getDictClient().getList(code);
            return (List)result.getData();
        }, (Boolean)TENANT_MODE);
    }
}

