/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.system.feign;

import com.baomidou.mybatisplus.core.metadata.IPage;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.springblade.core.tool.api.R;
import org.springblade.system.entity.DictBiz;
import org.springblade.system.feign.IDictBizClientFallback;
import org.springblade.system.vo.DictBizVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import springfox.documentation.annotations.ApiIgnore;

@FeignClient(value="blade-system", fallback=IDictBizClientFallback.class)
public interface IDictBizClient {
    public static final String API_PREFIX = "/client";
    public static final String GET_BY_ID = "/client/dict-biz/get-by-id";
    public static final String GET_VALUE = "/client/dict-biz/get-value";
    public static final String GET_LIST = "/client/dict-biz/get-list";
    public static final String DETAIL = "/client/dict-biz/detail";
    public static final String LIST = "/client/dict-biz/list";
    public static final String PARENT_LIST = "/client/dict-biz/parent-list";
    public static final String CHILD_LIST = "/client/dict-biz/child-list";
    public static final String TREE = "/client/dict-biz/tree";
    public static final String PARENT_TREE = "/client/dict-biz/parent-tree";
    public static final String SUBMIT = "/client/dict-biz/submit";
    public static final String REMOVE = "/client/dict-biz/remove";
    public static final String DICTIONARY = "/client/dict-biz/dictionary";
    public static final String DICTIONARY_TREE = "/client/dict-biz/dictionary-tree";
    public static final String SORT = "/client/dict-biz/sort";

    @GetMapping(value={"/client/dict-biz/get-by-id"})
    public R<DictBiz> getById(@RequestParam(value="id") Long var1);

    @GetMapping(value={"/client/dict-biz/get-value"})
    public R<String> getValue(@RequestParam(value="clientId") String var1, @RequestParam(value="code") String var2, @RequestParam(value="dictKey") String var3);

    @GetMapping(value={"/client/dict-biz/get-list"})
    public R<List<DictBiz>> getList(@RequestParam(value="clientId") String var1, @RequestParam(value="code") String var2);

    @GetMapping(value={"/client/dict-biz/detail"})
    public R<DictBizVO> detail(DictBiz var1);

    @GetMapping(value={"/client/dict-biz/list"})
    public R<List<DictBizVO>> list(@RequestParam Map<String, Object> var1);

    @GetMapping(value={"/client/dict-biz/parent-list"})
    public R<IPage<DictBizVO>> parentList(@RequestParam Map<String, Object> var1, @RequestParam(value="current") Integer var2, @RequestParam(value="size") Integer var3);

    @GetMapping(value={"/client/dict-biz/child-list"})
    public R<List<DictBizVO>> childList(@ApiIgnore @RequestParam Map<String, Object> var1, @RequestParam(required=false, defaultValue="-1") Long var2);

    @GetMapping(value={"/tree"})
    public R<List<DictBizVO>> tree(@RequestParam(value="clientId") String var1);

    @GetMapping(value={"/client/dict-biz/parent-tree"})
    public R<List<DictBizVO>> parentTree(@RequestParam(value="clientId") String var1);

    @PostMapping(value={"/client/dict-biz/submit"})
    public R submit(@Valid @RequestBody DictBiz var1);

    @PostMapping(value={"/client/dict-biz/remove"})
    public R remove(@ApiParam(value="\u4e3b\u952e\u96c6\u5408", required=true) @RequestParam String var1);

    @GetMapping(value={"/client/dict-biz/dictionary"})
    public R<List<DictBiz>> dictionary(@RequestParam(value="clientId") String var1, @RequestParam(value="code") String var2);

    @GetMapping(value={"/client/dict-biz/dictionary-tree"})
    public R<List<DictBizVO>> dictionaryTree(@RequestParam(value="clientId") String var1, @RequestParam(value="code") String var2);

    @PostMapping(value={"/client/dict-biz/sort"})
    public R sort(@RequestParam(value="clientId") String var1, @RequestParam(value="code") String var2, List<Long> var3);
}

