/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.system.cache;

import java.util.Collection;
import java.util.List;
import org.springblade.core.cache.utils.CacheUtil;
import org.springblade.core.datascope.model.DataScopeModel;
import org.springblade.core.tool.utils.CollectionUtil;
import org.springblade.core.tool.utils.SpringUtil;
import org.springblade.system.feign.IDataScopeClient;

public class DataScopeCache {
    private static final String SCOPE_CACHE_CODE = "dataScope:code:";
    private static final String SCOPE_CACHE_CLASS = "dataScope:class:";
    private static final String DEPT_CACHE_ANCESTORS = "dept:ancestors:";
    private static IDataScopeClient dataScopeClient;

    private static IDataScopeClient getDataScopeClient() {
        if (dataScopeClient == null) {
            dataScopeClient = (IDataScopeClient)SpringUtil.getBean(IDataScopeClient.class);
        }
        return dataScopeClient;
    }

    public static DataScopeModel getDataScopeByMapper(String mapperId, String roleId) {
        DataScopeModel dataScope = (DataScopeModel)CacheUtil.get((String)"blade:sys", (String)SCOPE_CACHE_CLASS, (Object)(mapperId + ":" + roleId), DataScopeModel.class);
        if (dataScope == null) {
            dataScope = DataScopeCache.getDataScopeClient().getDataScopeByMapper(mapperId, roleId);
            CacheUtil.put((String)"blade:sys", (String)SCOPE_CACHE_CLASS, (Object)(mapperId + ":" + roleId), (Object)dataScope);
        }
        return dataScope;
    }

    public static DataScopeModel getDataScopeByCode(String code) {
        DataScopeModel dataScope = (DataScopeModel)CacheUtil.get((String)"blade:sys", (String)SCOPE_CACHE_CODE, (Object)code, DataScopeModel.class);
        if (dataScope == null) {
            dataScope = DataScopeCache.getDataScopeClient().getDataScopeByCode(code);
            CacheUtil.put((String)"blade:sys", (String)SCOPE_CACHE_CODE, (Object)code, (Object)dataScope);
        }
        return dataScope;
    }

    public static List<Long> getDeptAncestors(Long deptId) {
        List<Long> ancestors = (List<Long>)CacheUtil.get((String)"blade:sys", (String)DEPT_CACHE_ANCESTORS, (Object)deptId, List.class);
        if (CollectionUtil.isEmpty((Collection)ancestors)) {
            ancestors = DataScopeCache.getDataScopeClient().getDeptAncestors(deptId);
            CacheUtil.put((String)"blade:sys", (String)DEPT_CACHE_ANCESTORS, (Object)deptId, ancestors);
        }
        return ancestors;
    }
}

