/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.system.handler;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springblade.core.secure.BladeUser;
import org.springblade.core.secure.handler.IPermissionHandler;
import org.springblade.core.secure.utils.AuthUtil;
import org.springblade.core.tool.utils.WebUtil;
import org.springblade.system.cache.ApiScopeCache;

public class ApiScopePermissionHandler
implements IPermissionHandler {
    public boolean permissionAll() {
        HttpServletRequest request = WebUtil.getRequest();
        BladeUser user = AuthUtil.getUser();
        if (request == null || user == null) {
            return false;
        }
        String uri = request.getRequestURI();
        List<String> paths = ApiScopeCache.permissionPath(user.getRoleId());
        if (paths == null || paths.size() == 0) {
            return false;
        }
        return paths.stream().anyMatch(uri::contains);
    }

    public boolean hasPermission(String permission) {
        HttpServletRequest request = WebUtil.getRequest();
        BladeUser user = AuthUtil.getUser();
        if (request == null || user == null) {
            return false;
        }
        List<String> codes = ApiScopeCache.permissionCode(permission, user.getRoleId());
        return codes != null && codes.size() != 0;
    }
}

