/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.system.cache;

import java.util.List;
import org.springblade.core.cache.utils.CacheUtil;
import org.springblade.core.tool.utils.SpringUtil;
import org.springblade.system.feign.IApiScopeClient;

public class ApiScopeCache {
    private static final String SCOPE_CACHE_CODE = "apiScope:code:";
    private static IApiScopeClient apiScopeClient;

    private static IApiScopeClient getApiScopeClient() {
        if (apiScopeClient == null) {
            apiScopeClient = (IApiScopeClient)SpringUtil.getBean(IApiScopeClient.class);
        }
        return apiScopeClient;
    }

    public static List<String> permissionPath(String roleId) {
        List<String> permissions = (List<String>)CacheUtil.get((String)"blade:sys", (String)SCOPE_CACHE_CODE, (Object)roleId, List.class);
        if (permissions == null) {
            permissions = ApiScopeCache.getApiScopeClient().permissionPath(roleId);
            CacheUtil.put((String)"blade:sys", (String)SCOPE_CACHE_CODE, (Object)roleId, permissions);
        }
        return permissions;
    }

    public static List<String> permissionCode(String permission, String roleId) {
        List<String> permissions = (List<String>)CacheUtil.get((String)"blade:sys", (String)SCOPE_CACHE_CODE, (Object)(permission + ":" + roleId), List.class);
        if (permissions == null) {
            permissions = ApiScopeCache.getApiScopeClient().permissionCode(permission, roleId);
            CacheUtil.put((String)"blade:sys", (String)SCOPE_CACHE_CODE, (Object)(permission + ":" + roleId), permissions);
        }
        return permissions;
    }
}

