/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.secure.utils;

import io.jsonwebtoken.Claims;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.springblade.core.jwt.JwtUtil;
import org.springblade.core.jwt.props.JwtProperties;
import org.springblade.core.secure.BladeUser;
import org.springblade.core.tool.utils.Func;
import org.springblade.core.tool.utils.ObjectUtil;
import org.springblade.core.tool.utils.SpringUtil;
import org.springblade.core.tool.utils.StringUtil;
import org.springblade.core.tool.utils.WebUtil;

public class AuthUtil {
    private static final String BLADE_USER_REQUEST_ATTR = "_BLADE_USER_REQUEST_ATTR_";
    private static final String HEADER = "Blade-Auth";
    private static final String ACCOUNT = "account";
    private static final String USER_NAME = "user_name";
    private static final String NICK_NAME = "nick_name";
    private static final String USER_ID = "user_id";
    private static final String DEPT_ID = "dept_id";
    private static final String POST_ID = "post_id";
    private static final String ROLE_ID = "role_id";
    private static final String ROLE_NAME = "role_name";
    private static final String TENANT_ID = "tenant_id";
    private static final String OAUTH_ID = "oauth_id";
    private static final String CLIENT_ID = "client_id";
    private static JwtProperties jwtProperties;

    private static JwtProperties getJwtProperties() {
        if (jwtProperties == null) {
            jwtProperties = (JwtProperties)SpringUtil.getBean(JwtProperties.class);
        }
        return jwtProperties;
    }

    public static BladeUser getUser() {
        HttpServletRequest request = WebUtil.getRequest();
        if (request == null) {
            return null;
        }
        Object bladeUser = request.getAttribute(BLADE_USER_REQUEST_ATTR);
        if (bladeUser == null && (bladeUser = AuthUtil.getUser(request)) != null) {
            request.setAttribute(BLADE_USER_REQUEST_ATTR, bladeUser);
        }
        return (BladeUser)bladeUser;
    }

    public static BladeUser getUser(HttpServletRequest request) {
        Claims claims = AuthUtil.getClaims(request);
        if (claims == null) {
            return null;
        }
        String clientId = Func.toStr((Object)claims.get((Object)CLIENT_ID));
        Long userId = Func.toLong((Object)claims.get((Object)USER_ID));
        String tenantId = Func.toStr((Object)claims.get((Object)TENANT_ID));
        String oauthId = Func.toStr((Object)claims.get((Object)OAUTH_ID));
        String deptId = Func.toStrWithEmpty((Object)claims.get((Object)DEPT_ID), (String)"-1");
        String postId = Func.toStrWithEmpty((Object)claims.get((Object)POST_ID), (String)"-1");
        String roleId = Func.toStrWithEmpty((Object)claims.get((Object)ROLE_ID), (String)"-1");
        String account = Func.toStr((Object)claims.get((Object)ACCOUNT));
        String roleName = Func.toStr((Object)claims.get((Object)ROLE_NAME));
        String userName = Func.toStr((Object)claims.get((Object)USER_NAME));
        String nickName = Func.toStr((Object)claims.get((Object)NICK_NAME));
        BladeUser bladeUser = new BladeUser();
        bladeUser.setClientId(clientId);
        bladeUser.setUserId(userId);
        bladeUser.setTenantId(tenantId);
        bladeUser.setOauthId(oauthId);
        bladeUser.setAccount(account);
        bladeUser.setDeptId(deptId);
        bladeUser.setPostId(postId);
        bladeUser.setRoleId(roleId);
        bladeUser.setRoleName(roleName);
        bladeUser.setUserName(userName);
        bladeUser.setNickName(nickName);
        return bladeUser;
    }

    public static boolean isAdministrator() {
        return StringUtil.containsAny((CharSequence)AuthUtil.getUserRole(), (CharSequence[])new CharSequence[]{"administrator"});
    }

    public static Long getUserId() {
        BladeUser user = AuthUtil.getUser();
        return null == user ? -1L : user.getUserId();
    }

    public static Long getUserId(HttpServletRequest request) {
        BladeUser user = AuthUtil.getUser(request);
        return null == user ? -1L : user.getUserId();
    }

    public static String getUserAccount() {
        BladeUser user = AuthUtil.getUser();
        return null == user ? "" : user.getAccount();
    }

    public static String getUserAccount(HttpServletRequest request) {
        BladeUser user = AuthUtil.getUser(request);
        return null == user ? "" : user.getAccount();
    }

    public static String getUserName() {
        BladeUser user = AuthUtil.getUser();
        return null == user ? "" : user.getUserName();
    }

    public static String getUserName(HttpServletRequest request) {
        BladeUser user = AuthUtil.getUser(request);
        return null == user ? "" : user.getUserName();
    }

    public static String getNickName() {
        BladeUser user = AuthUtil.getUser();
        return null == user ? "" : user.getNickName();
    }

    public static String getNickName(HttpServletRequest request) {
        BladeUser user = AuthUtil.getUser(request);
        return null == user ? "" : user.getNickName();
    }

    public static String getDeptId() {
        BladeUser user = AuthUtil.getUser();
        return null == user ? "" : user.getDeptId();
    }

    public static String getDeptId(HttpServletRequest request) {
        BladeUser user = AuthUtil.getUser(request);
        return null == user ? "" : user.getDeptId();
    }

    public static String getPostId() {
        BladeUser user = AuthUtil.getUser();
        return null == user ? "" : user.getPostId();
    }

    public static String getPostId(HttpServletRequest request) {
        BladeUser user = AuthUtil.getUser(request);
        return null == user ? "" : user.getPostId();
    }

    public static String getUserRole() {
        BladeUser user = AuthUtil.getUser();
        return null == user ? "" : user.getRoleName();
    }

    public static String getUserRole(HttpServletRequest request) {
        BladeUser user = AuthUtil.getUser(request);
        return null == user ? "" : user.getRoleName();
    }

    public static String getTenantId() {
        BladeUser user = AuthUtil.getUser();
        return null == user ? "" : user.getTenantId();
    }

    public static String getTenantId(HttpServletRequest request) {
        BladeUser user = AuthUtil.getUser(request);
        return null == user ? "" : user.getTenantId();
    }

    public static String getOauthId() {
        BladeUser user = AuthUtil.getUser();
        return null == user ? "" : user.getOauthId();
    }

    public static String getOauthId(HttpServletRequest request) {
        BladeUser user = AuthUtil.getUser(request);
        return null == user ? "" : user.getOauthId();
    }

    public static String getClientId() {
        BladeUser user = AuthUtil.getUser();
        return null == user ? "" : user.getClientId();
    }

    public static String getClientId(HttpServletRequest request) {
        BladeUser user = AuthUtil.getUser(request);
        return null == user ? "" : user.getClientId();
    }

    public static Claims getClaims(HttpServletRequest request) {
        String userId;
        String tenantId;
        String accessToken;
        String token;
        String auth = request.getHeader(HEADER);
        Claims claims = null;
        if (StringUtil.isNotBlank((CharSequence)auth)) {
            token = JwtUtil.getToken((String)auth);
        } else {
            String parameter = request.getParameter(HEADER);
            token = JwtUtil.getToken((String)parameter);
        }
        if (StringUtil.isNotBlank((CharSequence)token)) {
            claims = AuthUtil.parseJWT(token);
        }
        if (ObjectUtil.isNotEmpty(claims) && AuthUtil.getJwtProperties().getState().booleanValue() && !token.equalsIgnoreCase(accessToken = JwtUtil.getAccessToken((String)(tenantId = Func.toStr((Object)claims.get((Object)TENANT_ID))), (String)(userId = Func.toStr((Object)claims.get((Object)USER_ID))), (String)token))) {
            return null;
        }
        return claims;
    }

    public static String getHeader() {
        return AuthUtil.getHeader(Objects.requireNonNull(WebUtil.getRequest()));
    }

    public static String getHeader(HttpServletRequest request) {
        return request.getHeader(HEADER);
    }

    public static Claims parseJWT(String jsonWebToken) {
        return JwtUtil.parseJWT((String)jsonWebToken);
    }
}

