/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.cache.utils;

import java.lang.reflect.Field;
import java.util.concurrent.Callable;
import org.springblade.core.secure.utils.AuthUtil;
import org.springblade.core.tool.utils.ClassUtil;
import org.springblade.core.tool.utils.Func;
import org.springblade.core.tool.utils.ObjectUtil;
import org.springblade.core.tool.utils.ReflectUtil;
import org.springblade.core.tool.utils.SpringUtil;
import org.springblade.core.tool.utils.StringUtil;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.lang.Nullable;

public class CacheUtil {
    private static CacheManager cacheManager;
    private static final Boolean TENANT_MODE;

    private static CacheManager getCacheManager() {
        if (cacheManager == null) {
            cacheManager = (CacheManager)SpringUtil.getBean(CacheManager.class);
        }
        return cacheManager;
    }

    public static Cache getCache(String cacheName) {
        return CacheUtil.getCache(cacheName, TENANT_MODE);
    }

    public static Cache getCache(String cacheName, Boolean tenantMode) {
        return CacheUtil.getCacheManager().getCache(CacheUtil.formatCacheName(cacheName, tenantMode));
    }

    public static String formatCacheName(String cacheName, Boolean tenantMode) {
        if (!tenantMode.booleanValue()) {
            return cacheName;
        }
        String tenantId = AuthUtil.getTenantId();
        return StringUtil.isBlank((CharSequence)tenantId) ? cacheName : tenantId.concat(":").concat(cacheName);
    }

    @Nullable
    public static Object get(String cacheName, String keyPrefix, Object key) {
        return CacheUtil.get(cacheName, keyPrefix, key, TENANT_MODE);
    }

    @Nullable
    public static Object get(String cacheName, String keyPrefix, Object key, Boolean tenantMode) {
        if (Func.hasEmpty((Object[])new Object[]{cacheName, keyPrefix, key})) {
            return null;
        }
        Cache.ValueWrapper valueWrapper = CacheUtil.getCache(cacheName, tenantMode).get((Object)keyPrefix.concat(String.valueOf(key)));
        if (Func.isEmpty((Object)valueWrapper)) {
            return null;
        }
        return valueWrapper.get();
    }

    @Nullable
    public static <T> T get(String cacheName, String keyPrefix, Object key, @Nullable Class<T> type) {
        return CacheUtil.get(cacheName, keyPrefix, key, type, TENANT_MODE);
    }

    @Nullable
    public static <T> T get(String cacheName, String keyPrefix, Object key, @Nullable Class<T> type, Boolean tenantMode) {
        if (Func.hasEmpty((Object[])new Object[]{cacheName, keyPrefix, key})) {
            return null;
        }
        return (T)CacheUtil.getCache(cacheName, tenantMode).get((Object)keyPrefix.concat(String.valueOf(key)), type);
    }

    @Nullable
    public static <T> T get(String cacheName, String keyPrefix, Object key, Callable<T> valueLoader) {
        return CacheUtil.get(cacheName, keyPrefix, key, valueLoader, TENANT_MODE);
    }

    @Nullable
    public static <T> T get(String cacheName, String keyPrefix, Object key, Callable<T> valueLoader, Boolean tenantMode) {
        if (Func.hasEmpty((Object[])new Object[]{cacheName, keyPrefix, key})) {
            return null;
        }
        try {
            Cache.ValueWrapper valueWrapper = CacheUtil.getCache(cacheName, tenantMode).get((Object)keyPrefix.concat(String.valueOf(key)));
            Object value = null;
            if (valueWrapper == null) {
                T call = valueLoader.call();
                if (ObjectUtil.isNotEmpty(call)) {
                    Field field = ReflectUtil.getField(call.getClass(), (String)"id");
                    if (ObjectUtil.isNotEmpty((Object)field) && ObjectUtil.isEmpty((Object)ClassUtil.getMethod(call.getClass(), (String)"getId", (Class[])new Class[0]).invoke(call, new Object[0]))) {
                        return null;
                    }
                    CacheUtil.getCache(cacheName, tenantMode).put((Object)keyPrefix.concat(String.valueOf(key)), call);
                    value = call;
                }
            } else {
                value = valueWrapper.get();
            }
            return (T)value;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static void put(String cacheName, String keyPrefix, Object key, @Nullable Object value) {
        CacheUtil.put(cacheName, keyPrefix, key, value, TENANT_MODE);
    }

    public static void put(String cacheName, String keyPrefix, Object key, @Nullable Object value, Boolean tenantMode) {
        CacheUtil.getCache(cacheName, tenantMode).put((Object)keyPrefix.concat(String.valueOf(key)), value);
    }

    public static void evict(String cacheName, String keyPrefix, Object key) {
        CacheUtil.evict(cacheName, keyPrefix, key, TENANT_MODE);
    }

    public static void evict(String cacheName, String keyPrefix, Object key, Boolean tenantMode) {
        if (Func.hasEmpty((Object[])new Object[]{cacheName, keyPrefix, key})) {
            return;
        }
        CacheUtil.getCache(cacheName, tenantMode).evict((Object)keyPrefix.concat(String.valueOf(key)));
    }

    public static void clear(String cacheName) {
        CacheUtil.clear(cacheName, TENANT_MODE);
    }

    public static void clear(String cacheName, Boolean tenantMode) {
        if (Func.isEmpty((Object)cacheName)) {
            return;
        }
        CacheUtil.getCache(cacheName, tenantMode).clear();
    }

    static {
        TENANT_MODE = Boolean.TRUE;
    }
}

