/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.datascope.handler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springblade.core.cache.utils.CacheUtil;
import org.springblade.core.datascope.constant.DataScopeConstant;
import org.springblade.core.datascope.handler.ScopeModelHandler;
import org.springblade.core.datascope.model.DataScopeModel;
import org.springblade.core.tool.utils.CollectionUtil;
import org.springblade.core.tool.utils.Func;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class BladeScopeModelHandler
implements ScopeModelHandler {
    private static final String SCOPE_CACHE_CODE = "dataScope:code:";
    private static final String SCOPE_CACHE_CLASS = "dataScope:class:";
    private static final String DEPT_CACHE_ANCESTORS = "dept:ancestors:";
    private final JdbcTemplate jdbcTemplate;

    @Override
    public DataScopeModel getDataScopeByMapper(String mapperId, String roleId) {
        List list;
        ArrayList<String> args = new ArrayList<String>(Collections.singletonList(mapperId));
        List roleIds = Func.toLongList((String)roleId);
        args.addAll(roleIds);
        DataScopeModel dataScope = (DataScopeModel)CacheUtil.get((String)"blade:sys", (String)SCOPE_CACHE_CLASS, (Object)(mapperId + ":" + roleId), DataScopeModel.class);
        if (dataScope == null && CollectionUtil.isNotEmpty((Collection)(list = this.jdbcTemplate.query(DataScopeConstant.dataByMapper(roleIds.size()), args.toArray(), (RowMapper)new BeanPropertyRowMapper(DataScopeModel.class))))) {
            int[] sorts = new int[]{1, 4, 3, 5, 2};
            ArrayList sortedList = new ArrayList();
            for (int sort : sorts) {
                sortedList.addAll(list.stream().filter(it -> Func.equals((Object)it.getScopeType(), (Object)sort)).collect(Collectors.toList()));
            }
            dataScope = (DataScopeModel)sortedList.iterator().next();
            CacheUtil.put((String)"blade:sys", (String)SCOPE_CACHE_CLASS, (Object)(mapperId + ":" + roleId), (Object)dataScope);
        }
        return dataScope;
    }

    @Override
    public DataScopeModel getDataScopeByCode(String code) {
        List list;
        DataScopeModel dataScope = (DataScopeModel)CacheUtil.get((String)"blade:sys", (String)SCOPE_CACHE_CODE, (Object)code, DataScopeModel.class);
        if (dataScope == null && CollectionUtil.isNotEmpty((Collection)(list = this.jdbcTemplate.query("select resource_code, scope_column, scope_field, scope_type, scope_value from blade_scope_data where resource_code = ?", new Object[]{code}, (RowMapper)new BeanPropertyRowMapper(DataScopeModel.class))))) {
            dataScope = (DataScopeModel)list.iterator().next();
            CacheUtil.put((String)"blade:sys", (String)SCOPE_CACHE_CODE, (Object)code, (Object)dataScope);
        }
        return dataScope;
    }

    @Override
    public List<Long> getDeptAncestors(Long deptId) {
        List ancestors = (List)CacheUtil.get((String)"blade:sys", (String)DEPT_CACHE_ANCESTORS, (Object)deptId, List.class);
        if (CollectionUtil.isEmpty((Collection)ancestors)) {
            ancestors = this.jdbcTemplate.queryForList("select id from blade_dept where ancestors like concat(concat('%', ?),'%') and is_deleted = 0", new Object[]{deptId}, Long.class);
            CacheUtil.put((String)"blade:sys", (String)DEPT_CACHE_ANCESTORS, (Object)deptId, (Object)ancestors);
        }
        return ancestors;
    }

    public BladeScopeModelHandler(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }
}

