/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.datascope.interceptor;

import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.StatementType;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springblade.core.datascope.annotation.DataAuth;
import org.springblade.core.datascope.handler.DataScopeHandler;
import org.springblade.core.datascope.model.DataScopeModel;
import org.springblade.core.datascope.props.DataScopeProperties;
import org.springblade.core.mp.intercept.QueryInterceptor;
import org.springblade.core.secure.utils.AuthUtil;
import org.springblade.core.tool.utils.ClassUtil;
import org.springblade.core.tool.utils.SpringUtil;
import org.springblade.core.tool.utils.StringUtil;

public class DataScopeInterceptor
implements QueryInterceptor {
    private static final Logger log = LoggerFactory.getLogger(DataScopeInterceptor.class);
    private final ConcurrentMap<String, DataAuth> dataAuthMap = new ConcurrentHashMap<String, DataAuth>(8);
    private final DataScopeHandler dataScopeHandler;
    private final DataScopeProperties dataScopeProperties;

    /*
     * Unable to fully structure code
     */
    public void intercept(Executor executor, MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) {
        if (!this.dataScopeProperties.getEnabled().booleanValue()) {
            return;
        }
        bladeUser = AuthUtil.getUser();
        if (bladeUser == null) {
            return;
        }
        if (SqlCommandType.SELECT != ms.getSqlCommandType() || StatementType.CALLABLE == ms.getStatementType()) {
            return;
        }
        originalSql = boundSql.getSql();
        dataAuth = this.findDataAuthAnnotation(ms);
        mapperId = ms.getId();
        className = mapperId.substring(0, mapperId.lastIndexOf("."));
        mapperName = ClassUtil.getShortName((String)className);
        methodName = mapperId.substring(mapperId.lastIndexOf(".") + 1);
        if (this.dataScopeProperties.getMapperKey().stream().noneMatch((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, contains(java.lang.CharSequence ), (Ljava/lang/String;)Z)((String)methodName))) ** GOTO lbl-1000
        if (this.dataScopeProperties.getMapperExclude().stream().anyMatch((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, contains(java.lang.CharSequence ), (Ljava/lang/String;)Z)((String)mapperName))) lbl-1000:
        // 2 sources

        {
            v0 = true;
        } else {
            v0 = mapperSkip = false;
        }
        if (dataAuth == null && mapperSkip) {
            return;
        }
        dataScope = new DataScopeModel();
        if (dataAuth != null) {
            dataScope.setResourceCode(dataAuth.code());
            dataScope.setScopeColumn(dataAuth.column());
            dataScope.setScopeType(dataAuth.type().getType());
            dataScope.setScopeField(dataAuth.field());
            dataScope.setScopeValue(dataAuth.value());
        }
        if (!StringUtil.isBlank((CharSequence)(sqlCondition = this.dataScopeHandler.sqlCondition(mapperId, dataScope, bladeUser, originalSql)))) {
            mpBoundSql = PluginUtils.mpBoundSql((BoundSql)boundSql);
            mpBoundSql.sql(sqlCondition);
        }
    }

    private DataAuth findDataAuthAnnotation(MappedStatement mappedStatement) {
        String id = mappedStatement.getId();
        return this.dataAuthMap.computeIfAbsent(id, key -> {
            Class[] interfaces;
            String className = key.substring(0, key.lastIndexOf("."));
            String mapperBean = StringUtil.firstCharToLower((String)ClassUtil.getShortName((String)className));
            Object mapper = SpringUtil.getBean((String)mapperBean);
            String methodName = key.substring(key.lastIndexOf(".") + 1);
            for (Class mapperInterface : interfaces = ClassUtil.getAllInterfaces((Object)mapper)) {
                for (Method method : mapperInterface.getDeclaredMethods()) {
                    if (!methodName.equals(method.getName()) || !method.isAnnotationPresent(DataAuth.class)) continue;
                    return method.getAnnotation(DataAuth.class);
                }
            }
            return null;
        });
    }

    public DataScopeInterceptor(DataScopeHandler dataScopeHandler, DataScopeProperties dataScopeProperties) {
        this.dataScopeHandler = dataScopeHandler;
        this.dataScopeProperties = dataScopeProperties;
    }
}

