/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.datascope.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.springblade.core.datascope.enums.DataScopeEnum;
import org.springblade.core.datascope.handler.DataScopeHandler;
import org.springblade.core.datascope.handler.ScopeModelHandler;
import org.springblade.core.datascope.model.DataScopeModel;
import org.springblade.core.secure.BladeUser;
import org.springblade.core.tool.utils.BeanUtil;
import org.springblade.core.tool.utils.Func;
import org.springblade.core.tool.utils.PlaceholderUtil;
import org.springblade.core.tool.utils.StringUtil;

public class BladeDataScopeHandler
implements DataScopeHandler {
    private final ScopeModelHandler scopeModelHandler;

    @Override
    public String sqlCondition(String mapperId, DataScopeModel dataScope, BladeUser bladeUser, String originalSql) {
        String code = dataScope.getResourceCode();
        DataScopeModel dataScopeDb = this.scopeModelHandler.getDataScopeByMapper(mapperId, bladeUser.getRoleId());
        if (dataScopeDb == null && StringUtil.isNotBlank((CharSequence)code)) {
            dataScopeDb = this.scopeModelHandler.getDataScopeByCode(code);
        }
        dataScope = dataScopeDb != null ? dataScopeDb : dataScope;
        Integer scopeRule = Objects.requireNonNull(dataScope).getScopeType();
        DataScopeEnum scopeTypeEnum = DataScopeEnum.of(scopeRule);
        ArrayList<Long> ids = new ArrayList<Long>();
        String whereSql = "where scope.{} in ({})";
        if (DataScopeEnum.ALL == scopeTypeEnum || StringUtil.containsAny((CharSequence)bladeUser.getRoleName(), (CharSequence[])new CharSequence[]{"admin"})) {
            return null;
        }
        if (DataScopeEnum.CUSTOM == scopeTypeEnum) {
            whereSql = PlaceholderUtil.getDefaultResolver().resolveByMap(dataScope.getScopeValue(), BeanUtil.toMap((Object)bladeUser));
        } else if (DataScopeEnum.OWN == scopeTypeEnum) {
            ids.add(bladeUser.getUserId());
        } else if (DataScopeEnum.OWN_DEPT == scopeTypeEnum) {
            ids.addAll(Func.toLongList((String)bladeUser.getDeptId()));
        } else if (DataScopeEnum.OWN_DEPT_CHILD == scopeTypeEnum) {
            List deptIds = Func.toLongList((String)bladeUser.getDeptId());
            ids.addAll(deptIds);
            deptIds.forEach(deptId -> {
                List<Long> deptIdList = this.scopeModelHandler.getDeptAncestors((Long)deptId);
                ids.addAll(deptIdList);
            });
        }
        return StringUtil.format((String)("select {} from ({}) scope " + whereSql), (Object[])new Object[]{Func.toStr((Object)dataScope.getScopeField(), (String)"*"), originalSql, dataScope.getScopeColumn(), StringUtil.join(ids)});
    }

    @Generated
    public BladeDataScopeHandler(ScopeModelHandler scopeModelHandler) {
        this.scopeModelHandler = scopeModelHandler;
    }
}

