/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.excel.listener;

import cn.idev.excel.context.AnalysisContext;
import cn.idev.excel.event.AnalysisEventListener;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.springblade.core.excel.support.ExcelImporter;

public class ImportListener<T>
extends AnalysisEventListener<T> {
    private int batchCount = 3000;
    private List<T> list = new ArrayList<T>();
    private final ExcelImporter<T> importer;

    public void invoke(T data, AnalysisContext analysisContext) {
        this.list.add(data);
        if (this.list.size() >= this.batchCount) {
            this.importer.save(this.list);
            this.list.clear();
        }
    }

    public void doAfterAllAnalysed(AnalysisContext analysisContext) {
        this.importer.save(this.list);
        this.list.clear();
    }

    @Generated
    public int getBatchCount() {
        return this.batchCount;
    }

    @Generated
    public List<T> getList() {
        return this.list;
    }

    @Generated
    public ExcelImporter<T> getImporter() {
        return this.importer;
    }

    @Generated
    public void setBatchCount(int batchCount) {
        this.batchCount = batchCount;
    }

    @Generated
    public void setList(List<T> list) {
        this.list = list;
    }

    @Generated
    public String toString() {
        return "ImportListener(batchCount=" + this.getBatchCount() + ", list=" + this.getList() + ", importer=" + this.getImporter() + ")";
    }

    @Generated
    public ImportListener(ExcelImporter<T> importer) {
        this.importer = importer;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImportListener)) {
            return false;
        }
        ImportListener other = (ImportListener)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getBatchCount() != other.getBatchCount()) {
            return false;
        }
        List<T> this$list = this.getList();
        List<T> other$list = other.getList();
        if (this$list == null ? other$list != null : !((Object)this$list).equals(other$list)) {
            return false;
        }
        ExcelImporter<T> this$importer = this.getImporter();
        ExcelImporter<T> other$importer = other.getImporter();
        return !(this$importer == null ? other$importer != null : !this$importer.equals(other$importer));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ImportListener;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getBatchCount();
        List<T> $list = this.getList();
        result = result * 59 + ($list == null ? 43 : ((Object)$list).hashCode());
        ExcelImporter<T> $importer = this.getImporter();
        result = result * 59 + ($importer == null ? 43 : $importer.hashCode());
        return result;
    }
}

