/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.jwt;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.concurrent.TimeUnit;
import org.springblade.core.jwt.props.JwtProperties;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.StringUtils;

public class JwtUtil {
    public static String BEARER = "bearer";
    public static Integer AUTH_LENGTH = 7;
    private static final String TOKEN_CACHE = "blade:token";
    private static final String TOKEN_KEY = "token:state:";
    private static JwtProperties jwtProperties;
    private static RedisTemplate<String, Object> redisTemplate;

    public static JwtProperties getJwtProperties() {
        return jwtProperties;
    }

    public static void setJwtProperties(JwtProperties properties) {
        if (jwtProperties == null) {
            jwtProperties = properties;
        }
    }

    public static RedisTemplate<String, Object> getRedisTemplate() {
        return redisTemplate;
    }

    public static void setRedisTemplate(RedisTemplate<String, Object> redisTemplate) {
        if (JwtUtil.redisTemplate == null) {
            JwtUtil.redisTemplate = redisTemplate;
        }
    }

    public static String getBase64Security() {
        return Base64.getEncoder().encodeToString(JwtUtil.getJwtProperties().getSignKey().getBytes(StandardCharsets.UTF_8));
    }

    public static String getToken(String auth) {
        if (auth != null && auth.length() > AUTH_LENGTH) {
            String headStr = auth.substring(0, 6).toLowerCase();
            if (headStr.compareTo(BEARER) == 0) {
                auth = auth.substring(7);
            }
            return auth;
        }
        return null;
    }

    public static Claims parseJWT(String jsonWebToken) {
        try {
            return (Claims)Jwts.parserBuilder().setSigningKey(Base64.getDecoder().decode(JwtUtil.getBase64Security())).build().parseClaimsJws(jsonWebToken).getBody();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String getAccessToken(String tenantId, String userId, String accessToken) {
        return String.valueOf(JwtUtil.getRedisTemplate().opsForValue().get((Object)JwtUtil.getAccessTokenKey(tenantId, userId, accessToken)));
    }

    public static void addAccessToken(String tenantId, String userId, String accessToken, int expire) {
        JwtUtil.getRedisTemplate().delete((Object)JwtUtil.getAccessTokenKey(tenantId, userId, accessToken));
        JwtUtil.getRedisTemplate().opsForValue().set((Object)JwtUtil.getAccessTokenKey(tenantId, userId, accessToken), (Object)accessToken, (long)expire, TimeUnit.SECONDS);
    }

    public static void removeAccessToken(String tenantId, String userId) {
        JwtUtil.removeAccessToken(tenantId, userId, null);
    }

    public static void removeAccessToken(String tenantId, String userId, String accessToken) {
        JwtUtil.getRedisTemplate().delete((Object)JwtUtil.getAccessTokenKey(tenantId, userId, accessToken));
    }

    public static String getAccessTokenKey(String tenantId, String userId, String accessToken) {
        String key = tenantId.concat(":").concat(TOKEN_CACHE).concat("::").concat(TOKEN_KEY);
        if (JwtUtil.getJwtProperties().getSingle().booleanValue() || StringUtils.isEmpty((Object)accessToken)) {
            return key.concat(userId);
        }
        return key.concat(accessToken);
    }
}

