/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.jwt.config;

import org.springblade.core.jwt.JwtUtil;
import org.springblade.core.jwt.config.JwtRedisConfiguration;
import org.springblade.core.jwt.props.JwtProperties;
import org.springblade.core.jwt.serializer.JwtRedisKeySerializer;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.JdkSerializationRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;

@Configuration
@AutoConfigureAfter(value={JwtRedisConfiguration.class})
@EnableConfigurationProperties(value={JwtProperties.class})
public class JwtConfiguration
implements SmartInitializingSingleton {
    private final JwtProperties jwtProperties;
    private final RedisConnectionFactory redisConnectionFactory;

    public void afterSingletonsInstantiated() {
        RedisTemplate redisTemplate = new RedisTemplate();
        JwtRedisKeySerializer redisKeySerializer = new JwtRedisKeySerializer();
        JdkSerializationRedisSerializer jdkSerializationRedisSerializer = new JdkSerializationRedisSerializer();
        redisTemplate.setKeySerializer((RedisSerializer)redisKeySerializer);
        redisTemplate.setHashKeySerializer((RedisSerializer)redisKeySerializer);
        redisTemplate.setValueSerializer((RedisSerializer)jdkSerializationRedisSerializer);
        redisTemplate.setHashValueSerializer((RedisSerializer)jdkSerializationRedisSerializer);
        redisTemplate.setConnectionFactory(this.redisConnectionFactory);
        redisTemplate.afterPropertiesSet();
        JwtUtil.setJwtProperties(this.jwtProperties);
        JwtUtil.setRedisTemplate((RedisTemplate<String, Object>)redisTemplate);
    }

    public JwtConfiguration(JwtProperties jwtProperties, RedisConnectionFactory redisConnectionFactory) {
        this.jwtProperties = jwtProperties;
        this.redisConnectionFactory = redisConnectionFactory;
    }
}

