/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.log.config;

import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.springblade.core.launch.props.BladeProperties;
import org.springblade.core.launch.props.BladePropertySource;
import org.springblade.core.launch.server.ServerInfo;
import org.springblade.core.log.aspect.ApiLogAspect;
import org.springblade.core.log.aspect.LogTraceAspect;
import org.springblade.core.log.event.ApiLogListener;
import org.springblade.core.log.event.ErrorLogListener;
import org.springblade.core.log.event.UsualLogListener;
import org.springblade.core.log.feign.ILogClient;
import org.springblade.core.log.filter.LogTraceFilter;
import org.springblade.core.log.logger.BladeLogger;
import org.springblade.core.log.props.BladeRequestLogProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnWebApplication
@EnableConfigurationProperties(value={BladeRequestLogProperties.class})
@BladePropertySource(value="classpath:/blade-log.yml")
public class BladeLogToolAutoConfiguration {
    @Bean
    public ApiLogAspect apiLogAspect() {
        return new ApiLogAspect();
    }

    @Bean
    public LogTraceAspect logTraceAspect() {
        return new LogTraceAspect();
    }

    @Bean
    public BladeLogger bladeLogger() {
        return new BladeLogger();
    }

    @Bean
    public FilterRegistrationBean<LogTraceFilter> logTraceFilterRegistration() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setDispatcherTypes(DispatcherType.REQUEST, new DispatcherType[0]);
        registration.setFilter((Filter)new LogTraceFilter());
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setName("LogTraceFilter");
        registration.setOrder(Integer.MAX_VALUE);
        return registration;
    }

    @Bean
    @ConditionalOnMissingBean(name={"apiLogListener"})
    public ApiLogListener apiLogListener(ILogClient logService, ServerInfo serverInfo, BladeProperties bladeProperties) {
        return new ApiLogListener(logService, serverInfo, bladeProperties);
    }

    @Bean
    @ConditionalOnMissingBean(name={"errorEventListener"})
    public ErrorLogListener errorEventListener(ILogClient logService, ServerInfo serverInfo, BladeProperties bladeProperties) {
        return new ErrorLogListener(logService, serverInfo, bladeProperties);
    }

    @Bean
    @ConditionalOnMissingBean(name={"usualEventListener"})
    public UsualLogListener usualEventListener(ILogClient logService, ServerInfo serverInfo, BladeProperties bladeProperties) {
        return new UsualLogListener(logService, serverInfo, bladeProperties);
    }
}

