/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.log.error;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springblade.core.log.publisher.ErrorLogPublisher;
import org.springblade.core.tool.api.IResultCode;
import org.springblade.core.tool.api.R;
import org.springblade.core.tool.api.ResultCode;
import org.springblade.core.tool.utils.BeanUtil;
import org.springframework.boot.web.servlet.error.DefaultErrorAttributes;
import org.springframework.lang.Nullable;
import org.springframework.web.context.request.WebRequest;

public class BladeErrorAttributes
extends DefaultErrorAttributes {
    private static final Logger log = LoggerFactory.getLogger(BladeErrorAttributes.class);

    public Map<String, Object> getErrorAttributes(WebRequest webRequest, boolean includeStackTrace) {
        R result;
        String requestUri = (String)this.getAttr(webRequest, "javax.servlet.error.request_uri");
        Integer status = (Integer)this.getAttr(webRequest, "javax.servlet.error.status_code");
        Throwable error = this.getError(webRequest);
        if (error == null) {
            log.error("URL:{} error status:{}", (Object)requestUri, (Object)status);
            result = R.fail((IResultCode)ResultCode.FAILURE, (String)("\u7cfb\u7edf\u672a\u77e5\u5f02\u5e38[HttpStatus]:" + status));
        } else {
            log.error(String.format("URL:%s error status:%d", requestUri, status), error);
            result = R.fail((int)status, (String)error.getMessage());
        }
        ErrorLogPublisher.publishEvent(error, requestUri);
        return BeanUtil.toMap((Object)result);
    }

    @Nullable
    private <T> T getAttr(WebRequest webRequest, String name) {
        return (T)webRequest.getAttribute(name, 0);
    }
}

