/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.log.error;

import javax.servlet.Servlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springblade.core.log.exception.ServiceException;
import org.springblade.core.log.publisher.ErrorLogPublisher;
import org.springblade.core.secure.exception.SecureException;
import org.springblade.core.tool.api.IResultCode;
import org.springblade.core.tool.api.R;
import org.springblade.core.tool.api.ResultCode;
import org.springblade.core.tool.utils.Func;
import org.springblade.core.tool.utils.UrlUtil;
import org.springblade.core.tool.utils.WebUtil;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.DispatcherServlet;

@Order
@Configuration
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass(value={Servlet.class, DispatcherServlet.class})
@RestControllerAdvice
public class BladeRestExceptionTranslator {
    private static final Logger log = LoggerFactory.getLogger(BladeRestExceptionTranslator.class);

    @ExceptionHandler(value={ServiceException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R handleError(ServiceException e) {
        log.error("\u4e1a\u52a1\u5f02\u5e38", (Throwable)e);
        return R.fail((IResultCode)e.getResultCode(), (String)e.getMessage());
    }

    @ExceptionHandler(value={SecureException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public R handleError(SecureException e) {
        log.error("\u8ba4\u8bc1\u5f02\u5e38", (Throwable)e);
        return R.fail((IResultCode)e.getResultCode(), (String)e.getMessage());
    }

    @ExceptionHandler(value={Throwable.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public R handleError(Throwable e) {
        log.error("\u670d\u52a1\u5668\u5f02\u5e38", e);
        ErrorLogPublisher.publishEvent(e, UrlUtil.getPath((String)WebUtil.getRequest().getRequestURI()));
        return R.fail((IResultCode)ResultCode.INTERNAL_SERVER_ERROR, (String)(Func.isEmpty((Object)e.getMessage()) ? ResultCode.INTERNAL_SERVER_ERROR.getMessage() : e.getMessage()));
    }
}

