/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.mongo.utils;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.LinkedList;
import java.util.StringJoiner;
import org.springframework.util.Assert;

public class JsonNodeInfo {
    private volatile String nodeKeys;
    private volatile String nodePath;
    private final LinkedList<String> elements;
    private final JsonNode leafNode;

    public JsonNodeInfo(LinkedList<String> elements, JsonNode leafNode) {
        Assert.notNull(elements, (String)"elements can not be null.");
        this.nodeKeys = null;
        this.nodePath = null;
        this.elements = elements;
        this.leafNode = leafNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNodeKeys() {
        if (this.nodeKeys == null) {
            JsonNodeInfo jsonNodeInfo = this;
            synchronized (jsonNodeInfo) {
                if (this.nodeKeys == null) {
                    StringJoiner nodeKeysJoiner = new StringJoiner(".");
                    this.elements.forEach(nodeKeysJoiner::add);
                    this.nodeKeys = nodeKeysJoiner.toString();
                }
            }
        }
        return this.nodeKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNodePath() {
        if (this.nodePath == null) {
            JsonNodeInfo jsonNodeInfo = this;
            synchronized (jsonNodeInfo) {
                if (this.nodePath == null) {
                    StringJoiner nodePathJoiner = new StringJoiner("/", "/", "");
                    this.elements.forEach(nodePathJoiner::add);
                    this.nodePath = nodePathJoiner.toString();
                }
            }
        }
        return this.nodePath;
    }

    public String getFirst() {
        return this.elements.getFirst();
    }

    public LinkedList<String> getElements() {
        return this.elements;
    }

    public JsonNode getLeafNode() {
        return this.leafNode;
    }
}

