/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.mongo.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springblade.core.mongo.utils.JsonNodeInfo;

public class MongoJsonUtils {
    public static List<JsonNodeInfo> getLeafNodes(JsonNode jsonNode) {
        if (jsonNode == null || !jsonNode.isObject()) {
            return Collections.emptyList();
        }
        ArrayList<JsonNodeInfo> list = new ArrayList<JsonNodeInfo>();
        LinkedList<String> deque = new LinkedList<String>();
        MongoJsonUtils.getLeafNodes(jsonNode, null, deque, list);
        return list;
    }

    private static void getLeafNodes(JsonNode jsonNode, JsonNode parentNode, LinkedList<String> deque, List<JsonNodeInfo> list) {
        Iterator iterator = parentNode == null ? jsonNode.fields() : parentNode.fields();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String fieldName = (String)entry.getKey();
            JsonNode nextNode = (JsonNode)entry.getValue();
            if (nextNode.isObject()) {
                deque.addLast(fieldName);
                MongoJsonUtils.getLeafNodes(parentNode, nextNode, deque, list);
            }
            if (nextNode.isValueNode()) {
                LinkedList<String> elements = new LinkedList<String>(deque);
                list.add(new JsonNodeInfo(elements, parentNode));
                break;
            }
            if (deque.isEmpty()) continue;
            deque.removeLast();
        }
    }

    public static ObjectNode buildNode(ObjectNode jsonNode, List<String> elements) {
        ObjectNode newNode = jsonNode;
        for (String element : elements) {
            if (newNode.has(element)) {
                newNode = (ObjectNode)newNode.get(element);
                continue;
            }
            newNode = newNode.putObject(element);
        }
        return newNode;
    }

    public static Map<String, Object> getAllUpdate(String prefix, String nodeKeys, ObjectNode objectNode) {
        HashMap<String, Object> values = new HashMap<String, Object>(8);
        Iterator iterator = objectNode.fieldNames();
        while (iterator.hasNext()) {
            Object value;
            String fieldName = (String)iterator.next();
            JsonNode valueNode = objectNode.get(fieldName);
            if (!valueNode.isValueNode() || (value = valueNode.isShort() ? Short.valueOf(valueNode.shortValue()) : (valueNode.isInt() ? Integer.valueOf(valueNode.intValue()) : (valueNode.isLong() ? Long.valueOf(valueNode.longValue()) : (valueNode.isBoolean() ? Boolean.valueOf(valueNode.booleanValue()) : (valueNode.isFloat() ? Float.valueOf(valueNode.floatValue()) : (valueNode.isDouble() ? Double.valueOf(valueNode.doubleValue()) : (valueNode.isMissingNode() ? null : valueNode.textValue()))))))) == null) continue;
            String valueKey = prefix + '.' + nodeKeys + '.' + fieldName;
            values.put(valueKey, value);
        }
        return values;
    }
}

