/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.mp.plugins;

import com.alibaba.druid.DbType;
import com.alibaba.druid.filter.FilterChain;
import com.alibaba.druid.filter.FilterEventAdapter;
import com.alibaba.druid.proxy.jdbc.JdbcParameter;
import com.alibaba.druid.proxy.jdbc.ResultSetProxy;
import com.alibaba.druid.proxy.jdbc.StatementProxy;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.util.StringUtils;
import java.sql.SQLException;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springblade.core.mp.props.MybatisPlusProperties;
import org.springblade.core.tool.utils.StringUtil;

public class SqlLogInterceptor
extends FilterEventAdapter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SqlLogInterceptor.class);
    private static final SQLUtils.FormatOption FORMAT_OPTION = new SQLUtils.FormatOption(false, false);
    private final MybatisPlusProperties properties;

    protected void statementExecuteBefore(StatementProxy statement, String sql) {
        statement.setLastExecuteStartNano();
    }

    protected void statementExecuteBatchBefore(StatementProxy statement) {
        statement.setLastExecuteStartNano();
    }

    protected void statementExecuteUpdateBefore(StatementProxy statement, String sql) {
        statement.setLastExecuteStartNano();
    }

    protected void statementExecuteQueryBefore(StatementProxy statement, String sql) {
        statement.setLastExecuteStartNano();
    }

    protected void statementExecuteAfter(StatementProxy statement, String sql, boolean firstResult) {
        statement.setLastExecuteTimeNano();
    }

    protected void statementExecuteBatchAfter(StatementProxy statement, int[] result) {
        statement.setLastExecuteTimeNano();
    }

    protected void statementExecuteQueryAfter(StatementProxy statement, String sql, ResultSetProxy resultSet) {
        statement.setLastExecuteTimeNano();
    }

    protected void statementExecuteUpdateAfter(StatementProxy statement, String sql, int updateCount) {
        statement.setLastExecuteTimeNano();
    }

    public void statement_close(FilterChain chain, StatementProxy statement) throws SQLException {
        super.statement_close(chain, statement);
        if (!this.properties.isSqlLog()) {
            return;
        }
        if (!log.isInfoEnabled()) {
            return;
        }
        String sql = statement.getBatchSql();
        if (StringUtils.isEmpty((CharSequence)sql)) {
            return;
        }
        int parametersSize = statement.getParametersSize();
        ArrayList<Object> parameters = new ArrayList<Object>(parametersSize);
        for (int i = 0; i < parametersSize; ++i) {
            parameters.add(SqlLogInterceptor.getJdbcParameter(statement.getParameter(i)));
        }
        String dbType = statement.getConnectionProxy().getDirectDataSource().getDbType();
        String formattedSql = SQLUtils.format((String)sql, (DbType)DbType.of((String)dbType), parameters, (SQLUtils.FormatOption)FORMAT_OPTION);
        SqlLogInterceptor.printSql(formattedSql, statement);
    }

    private static Object getJdbcParameter(JdbcParameter jdbcParam) {
        if (jdbcParam == null) {
            return null;
        }
        Object value = jdbcParam.getValue();
        if (value instanceof TemporalAccessor) {
            return value.toString();
        }
        return value;
    }

    private static void printSql(String sql, StatementProxy statement) {
        String sqlLogger = "\n\n=================== Sql Logger ===================\n{}\n============ Sql Execute Time: {} ===========\n";
        log.info(sqlLogger, (Object)sql.trim(), (Object)StringUtil.format((long)statement.getLastExecuteTimeNano()));
    }

    @Generated
    public SqlLogInterceptor(MybatisPlusProperties properties) {
        this.properties = properties;
    }
}

