/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.oss.minio;

import io.minio.MinioClient;
import io.minio.ObjectStat;
import io.minio.messages.Bucket;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import org.springblade.core.oss.OssTemplate;
import org.springblade.core.oss.minio.enums.PolicyType;
import org.springblade.core.oss.model.BladeFile;
import org.springblade.core.oss.model.OssFile;
import org.springblade.core.oss.props.OssProperties;
import org.springblade.core.oss.rule.OssRule;
import org.springblade.core.tool.utils.Func;
import org.springframework.web.multipart.MultipartFile;

public class MinioTemplate
implements OssTemplate {
    private final MinioClient client;
    private final OssRule ossRule;
    private final OssProperties ossProperties;

    public void makeBucket(String bucketName) {
        if (!this.client.bucketExists(this.getBucketName(bucketName))) {
            this.client.makeBucket(this.getBucketName(bucketName));
            this.client.setBucketPolicy(this.getBucketName(bucketName), MinioTemplate.getPolicyType(this.getBucketName(bucketName), PolicyType.READ));
        }
    }

    public Bucket getBucket() {
        return this.getBucket(this.getBucketName());
    }

    public Bucket getBucket(String bucketName) {
        Optional<Bucket> bucketOptional = this.client.listBuckets().stream().filter(bucket -> bucket.name().equals(this.getBucketName(bucketName))).findFirst();
        return bucketOptional.orElse(null);
    }

    public List<Bucket> listBuckets() {
        return this.client.listBuckets();
    }

    public void removeBucket(String bucketName) {
        this.client.removeBucket(this.getBucketName(bucketName));
    }

    public boolean bucketExists(String bucketName) {
        return this.client.bucketExists(this.getBucketName(bucketName));
    }

    public void copyFile(String bucketName, String fileName, String destBucketName) {
        this.client.copyObject(this.getBucketName(bucketName), fileName, this.getBucketName(destBucketName));
    }

    public void copyFile(String bucketName, String fileName, String destBucketName, String destFileName) {
        this.client.copyObject(this.getBucketName(bucketName), fileName, this.getBucketName(destBucketName), destFileName);
    }

    public OssFile statFile(String fileName) {
        return this.statFile(this.ossProperties.getBucketName(), fileName);
    }

    public OssFile statFile(String bucketName, String fileName) {
        ObjectStat stat = this.client.statObject(this.getBucketName(bucketName), fileName);
        OssFile ossFile = new OssFile();
        ossFile.setName(Func.isEmpty((Object)stat.name()) ? fileName : stat.name());
        ossFile.setLink(this.fileLink(ossFile.getName()));
        ossFile.setHash(String.valueOf(stat.hashCode()));
        ossFile.setLength(stat.length());
        ossFile.setPutTime(stat.createdTime());
        ossFile.setContentType(stat.contentType());
        return ossFile;
    }

    public String filePath(String fileName) {
        return this.getBucketName().concat("/").concat(fileName);
    }

    public String filePath(String bucketName, String fileName) {
        return this.getBucketName(bucketName).concat("/").concat(fileName);
    }

    public String fileLink(String fileName) {
        return this.ossProperties.getEndpoint().concat("/").concat(this.getBucketName()).concat("/").concat(fileName);
    }

    public String fileLink(String bucketName, String fileName) {
        return this.ossProperties.getEndpoint().concat("/").concat(this.getBucketName(bucketName)).concat("/").concat(fileName);
    }

    public BladeFile putFile(MultipartFile file) {
        return this.putFile(this.ossProperties.getBucketName(), file.getOriginalFilename(), file);
    }

    public BladeFile putFile(String fileName, MultipartFile file) {
        return this.putFile(this.ossProperties.getBucketName(), fileName, file);
    }

    public BladeFile putFile(String bucketName, String fileName, MultipartFile file) {
        return this.putFile(bucketName, file.getOriginalFilename(), file.getInputStream());
    }

    public BladeFile putFile(String fileName, InputStream stream) {
        return this.putFile(this.ossProperties.getBucketName(), fileName, stream);
    }

    public BladeFile putFile(String bucketName, String fileName, InputStream stream) {
        return this.putFile(bucketName, fileName, stream, "application/octet-stream");
    }

    public BladeFile putFile(String bucketName, String fileName, InputStream stream, String contentType) {
        this.makeBucket(bucketName);
        String originalName = fileName;
        fileName = this.getFileName(fileName);
        this.client.putObject(this.getBucketName(bucketName), fileName, stream, Long.valueOf(stream.available()), null, null, contentType);
        BladeFile file = new BladeFile();
        file.setOriginalName(originalName);
        file.setName(fileName);
        file.setDomain(this.getOssHost(bucketName));
        file.setLink(this.fileLink(bucketName, fileName));
        return file;
    }

    public void removeFile(String fileName) {
        this.removeFile(this.ossProperties.getBucketName(), fileName);
    }

    public void removeFile(String bucketName, String fileName) {
        this.client.removeObject(this.getBucketName(bucketName), fileName);
    }

    public void removeFiles(List<String> fileNames) {
        this.removeFiles(this.ossProperties.getBucketName(), fileNames);
    }

    public void removeFiles(String bucketName, List<String> fileNames) {
        this.client.removeObjects(this.getBucketName(bucketName), fileNames);
    }

    private String getBucketName() {
        return this.getBucketName(this.ossProperties.getBucketName());
    }

    private String getBucketName(String bucketName) {
        return this.ossRule.bucketName(bucketName);
    }

    private String getFileName(String originalFilename) {
        return this.ossRule.fileName(originalFilename);
    }

    public String getPolicyType(PolicyType policyType) {
        return MinioTemplate.getPolicyType(this.getBucketName(), policyType);
    }

    public static String getPolicyType(String bucketName, PolicyType policyType) {
        StringBuilder builder = new StringBuilder();
        builder.append("{\n");
        builder.append("    \"Statement\": [\n");
        builder.append("        {\n");
        builder.append("            \"Action\": [\n");
        switch (policyType) {
            case WRITE: {
                builder.append("                \"s3:GetBucketLocation\",\n");
                builder.append("                \"s3:ListBucketMultipartUploads\"\n");
                break;
            }
            case READ_WRITE: {
                builder.append("                \"s3:GetBucketLocation\",\n");
                builder.append("                \"s3:ListBucket\",\n");
                builder.append("                \"s3:ListBucketMultipartUploads\"\n");
                break;
            }
            default: {
                builder.append("                \"s3:GetBucketLocation\"\n");
            }
        }
        builder.append("            ],\n");
        builder.append("            \"Effect\": \"Allow\",\n");
        builder.append("            \"Principal\": \"*\",\n");
        builder.append("            \"Resource\": \"arn:aws:s3:::");
        builder.append(bucketName);
        builder.append("\"\n");
        builder.append("        },\n");
        if (PolicyType.READ.equals((Object)policyType)) {
            builder.append("        {\n");
            builder.append("            \"Action\": [\n");
            builder.append("                \"s3:ListBucket\"\n");
            builder.append("            ],\n");
            builder.append("            \"Effect\": \"Deny\",\n");
            builder.append("            \"Principal\": \"*\",\n");
            builder.append("            \"Resource\": \"arn:aws:s3:::");
            builder.append(bucketName);
            builder.append("\"\n");
            builder.append("        },\n");
        }
        builder.append("        {\n");
        builder.append("            \"Action\": ");
        switch (policyType) {
            case WRITE: {
                builder.append("[\n");
                builder.append("                \"s3:AbortMultipartUpload\",\n");
                builder.append("                \"s3:DeleteObject\",\n");
                builder.append("                \"s3:ListMultipartUploadParts\",\n");
                builder.append("                \"s3:PutObject\"\n");
                builder.append("            ],\n");
                break;
            }
            case READ_WRITE: {
                builder.append("[\n");
                builder.append("                \"s3:AbortMultipartUpload\",\n");
                builder.append("                \"s3:DeleteObject\",\n");
                builder.append("                \"s3:GetObject\",\n");
                builder.append("                \"s3:ListMultipartUploadParts\",\n");
                builder.append("                \"s3:PutObject\"\n");
                builder.append("            ],\n");
                break;
            }
            default: {
                builder.append("\"s3:GetObject\",\n");
            }
        }
        builder.append("            \"Effect\": \"Allow\",\n");
        builder.append("            \"Principal\": \"*\",\n");
        builder.append("            \"Resource\": \"arn:aws:s3:::");
        builder.append(bucketName);
        builder.append("/*\"\n");
        builder.append("        }\n");
        builder.append("    ],\n");
        builder.append("    \"Version\": \"2012-10-17\"\n");
        builder.append("}\n");
        return builder.toString();
    }

    public String getOssHost(String bucketName) {
        return this.ossProperties.getEndpoint() + "/" + this.getBucketName(bucketName);
    }

    public String getOssHost() {
        return this.getOssHost(this.ossProperties.getBucketName());
    }

    public MinioTemplate(MinioClient client, OssRule ossRule, OssProperties ossProperties) {
        this.client = client;
        this.ossRule = ossRule;
        this.ossProperties = ossProperties;
    }
}

