/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.oss.qiniu;

import com.qiniu.common.Zone;
import com.qiniu.http.Response;
import com.qiniu.storage.BucketManager;
import com.qiniu.storage.UploadManager;
import com.qiniu.storage.model.FileInfo;
import com.qiniu.util.Auth;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import org.springblade.core.oss.OssTemplate;
import org.springblade.core.oss.model.BladeFile;
import org.springblade.core.oss.model.OssFile;
import org.springblade.core.oss.props.OssProperties;
import org.springblade.core.oss.rule.OssRule;
import org.springblade.core.tool.utils.CollectionUtil;
import org.springblade.core.tool.utils.Func;
import org.springframework.web.multipart.MultipartFile;

public class QiniuTemplate
implements OssTemplate {
    private final Auth auth;
    private final UploadManager uploadManager;
    private final BucketManager bucketManager;
    private final OssProperties ossProperties;
    private final OssRule ossRule;

    public void makeBucket(String bucketName) {
        if (!CollectionUtil.contains((Object[])this.bucketManager.buckets(), (Object)this.getBucketName(bucketName))) {
            this.bucketManager.createBucket(this.getBucketName(bucketName), Zone.autoZone().getRegion());
        }
    }

    public void removeBucket(String bucketName) {
    }

    public boolean bucketExists(String bucketName) {
        return CollectionUtil.contains((Object[])this.bucketManager.buckets(), (Object)this.getBucketName(bucketName));
    }

    public void copyFile(String bucketName, String fileName, String destBucketName) {
        this.bucketManager.copy(this.getBucketName(bucketName), fileName, this.getBucketName(destBucketName), fileName);
    }

    public void copyFile(String bucketName, String fileName, String destBucketName, String destFileName) {
        this.bucketManager.copy(this.getBucketName(bucketName), fileName, this.getBucketName(destBucketName), destFileName);
    }

    public OssFile statFile(String fileName) {
        return this.statFile(this.ossProperties.getBucketName(), fileName);
    }

    public OssFile statFile(String bucketName, String fileName) {
        FileInfo stat = this.bucketManager.stat(this.getBucketName(bucketName), fileName);
        OssFile ossFile = new OssFile();
        ossFile.setName(Func.isEmpty((Object)stat.key) ? fileName : stat.key);
        ossFile.setLink(this.fileLink(ossFile.getName()));
        ossFile.setHash(stat.hash);
        ossFile.setLength(stat.fsize);
        ossFile.setPutTime(new Date(stat.putTime / 10000L));
        ossFile.setContentType(stat.mimeType);
        return ossFile;
    }

    public String filePath(String fileName) {
        return this.getBucketName().concat("/").concat(fileName);
    }

    public String filePath(String bucketName, String fileName) {
        return this.getBucketName(bucketName).concat("/").concat(fileName);
    }

    public String fileLink(String fileName) {
        return this.ossProperties.getEndpoint().concat("/").concat(fileName);
    }

    public String fileLink(String bucketName, String fileName) {
        return this.ossProperties.getEndpoint().concat("/").concat(fileName);
    }

    public BladeFile putFile(MultipartFile file) {
        return this.putFile(this.ossProperties.getBucketName(), file.getOriginalFilename(), file);
    }

    public BladeFile putFile(String fileName, MultipartFile file) {
        return this.putFile(this.ossProperties.getBucketName(), fileName, file);
    }

    public BladeFile putFile(String bucketName, String fileName, MultipartFile file) {
        return this.putFile(bucketName, fileName, file.getInputStream());
    }

    public BladeFile putFile(String fileName, InputStream stream) {
        return this.putFile(this.ossProperties.getBucketName(), fileName, stream);
    }

    public BladeFile putFile(String bucketName, String fileName, InputStream stream) {
        return this.put(bucketName, stream, fileName, false);
    }

    public BladeFile put(String bucketName, InputStream stream, String key, boolean cover) {
        this.makeBucket(bucketName);
        String originalName = key;
        key = this.getFileName(key);
        if (cover) {
            this.uploadManager.put(stream, key, this.getUploadToken(bucketName, key), null, null);
        } else {
            Response response = this.uploadManager.put(stream, key, this.getUploadToken(bucketName), null, null);
            int retryCount = 5;
            for (int retry = 0; response.needRetry() && retry < retryCount; ++retry) {
                response = this.uploadManager.put(stream, key, this.getUploadToken(bucketName), null, null);
            }
        }
        BladeFile file = new BladeFile();
        file.setOriginalName(originalName);
        file.setName(key);
        file.setDomain(this.getOssHost());
        file.setLink(this.fileLink(bucketName, key));
        return file;
    }

    public void removeFile(String fileName) {
        this.bucketManager.delete(this.getBucketName(), fileName);
    }

    public void removeFile(String bucketName, String fileName) {
        this.bucketManager.delete(this.getBucketName(bucketName), fileName);
    }

    public void removeFiles(List<String> fileNames) {
        fileNames.forEach(this::removeFile);
    }

    public void removeFiles(String bucketName, List<String> fileNames) {
        fileNames.forEach(fileName -> this.removeFile(this.getBucketName(bucketName), (String)fileName));
    }

    private String getBucketName() {
        return this.getBucketName(this.ossProperties.getBucketName());
    }

    private String getBucketName(String bucketName) {
        return this.ossRule.bucketName(bucketName);
    }

    private String getFileName(String originalFilename) {
        return this.ossRule.fileName(originalFilename);
    }

    public String getUploadToken(String bucketName) {
        return this.auth.uploadToken(this.getBucketName(bucketName));
    }

    private String getUploadToken(String bucketName, String key) {
        return this.auth.uploadToken(this.getBucketName(bucketName), key);
    }

    public String getOssHost() {
        return this.ossProperties.getEndpoint();
    }

    public QiniuTemplate(Auth auth, UploadManager uploadManager, BucketManager bucketManager, OssProperties ossProperties, OssRule ossRule) {
        this.auth = auth;
        this.uploadManager = uploadManager;
        this.bucketManager = bucketManager;
        this.ossProperties = ossProperties;
        this.ossRule = ossRule;
    }
}

