/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.redis.pubsub;

import lombok.Generated;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.PatternTopic;
import org.springframework.data.redis.listener.Topic;

final class ChannelUtil {
    public static Topic getTopic(String channel) {
        return ChannelUtil.isPattern(channel) ? new PatternTopic(channel) : new ChannelTopic(channel);
    }

    public static boolean isPattern(String channel) {
        int length = channel.length();
        boolean isRightSqBracket = false;
        block5: for (int i = length - 1; i > 0; --i) {
            char charAt = channel.charAt(i);
            switch (charAt) {
                case '*': 
                case '?': {
                    if (ChannelUtil.isEscapeChars(channel, i)) continue block5;
                    return true;
                }
                case ']': {
                    if (ChannelUtil.isEscapeChars(channel, i)) continue block5;
                    isRightSqBracket = true;
                    continue block5;
                }
                case '[': {
                    if (ChannelUtil.isEscapeChars(channel, i) || !isRightSqBracket) continue block5;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isEscapeChars(String name, int index) {
        if (index < 1) {
            return false;
        }
        char charAt = name.charAt(index - 1);
        return '\\' == charAt;
    }

    @Generated
    private ChannelUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

