/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.build.compute;

import com.bstek.ureport.build.BindData;
import com.bstek.ureport.build.Context;
import com.bstek.ureport.build.compute.ValueCompute;
import com.bstek.ureport.definition.value.Source;
import com.bstek.ureport.definition.value.ValueType;
import com.bstek.ureport.definition.value.ZxingValue;
import com.bstek.ureport.exception.ReportComputeException;
import com.bstek.ureport.expression.model.Expression;
import com.bstek.ureport.expression.model.data.BindDataListExpressionData;
import com.bstek.ureport.expression.model.data.ExpressionData;
import com.bstek.ureport.expression.model.data.ObjectExpressionData;
import com.bstek.ureport.expression.model.data.ObjectListExpressionData;
import com.bstek.ureport.model.Cell;
import com.bstek.ureport.model.Image;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springblade.core.tool.utils.Base64Util;

public class ZxingValueCompute
implements ValueCompute {
    private static final int BLACK = -16777216;
    private static final int WHITE = -1;

    public List<BindData> compute(Cell cell, Context context) {
        ArrayList<BindData> list;
        block13: {
            ExpressionData data;
            int h;
            int w;
            BarcodeFormat barcodeForamt;
            block15: {
                block14: {
                    ZxingValue value;
                    block12: {
                        list = new ArrayList<BindData>();
                        value = (ZxingValue)cell.getValue();
                        String format = value.getFormat();
                        barcodeForamt = BarcodeFormat.QR_CODE;
                        if (StringUtils.isNotBlank((CharSequence)format)) {
                            barcodeForamt = BarcodeFormat.valueOf((String)format);
                        }
                        w = value.getWidth();
                        h = value.getHeight();
                        Source source = value.getSource();
                        if (!source.equals((Object)Source.text)) break block12;
                        String data2 = value.getValue();
                        Image image = this.buildImage(barcodeForamt, data2, w, h);
                        list.add(new BindData((Object)image));
                        break block13;
                    }
                    Expression expression = value.getExpression();
                    data = expression.execute(cell, cell, context);
                    if (!(data instanceof BindDataListExpressionData)) break block14;
                    BindDataListExpressionData listData = (BindDataListExpressionData)data;
                    List bindDataList = listData.getData();
                    for (BindData bindData : bindDataList) {
                        Object obj = bindData.getValue();
                        if (obj == null) {
                            obj = "";
                        }
                        Image image = this.buildImage(barcodeForamt, obj.toString(), w, h);
                        list.add(new BindData((Object)image));
                    }
                    break block13;
                }
                if (!(data instanceof ObjectExpressionData)) break block15;
                ObjectExpressionData exprData = (ObjectExpressionData)data;
                Object obj = exprData.getData();
                if (obj == null) {
                    obj = "";
                } else if (obj instanceof String) {
                    String text = obj.toString();
                    if (text.startsWith("\"") && text.endsWith("\"")) {
                        text = text.substring(1, text.length() - 1);
                    }
                    obj = text;
                }
                Image image = this.buildImage(barcodeForamt, obj.toString(), w, h);
                list.add(new BindData((Object)image));
                break block13;
            }
            if (!(data instanceof ObjectListExpressionData)) break block13;
            ObjectListExpressionData listExprData = (ObjectListExpressionData)data;
            List listData = listExprData.getData();
            for (Object obj : listData) {
                if (obj == null) {
                    obj = "";
                } else if (obj instanceof String) {
                    String text = obj.toString();
                    if (text.startsWith("\"") && text.endsWith("\"")) {
                        text = text.substring(1, text.length() - 1);
                    }
                    obj = text;
                }
                Image image = this.buildImage(barcodeForamt, obj.toString(), w, h);
                list.add(new BindData((Object)image));
            }
        }
        return list;
    }

    private Image buildImage(BarcodeFormat format, String data, int w, int h) {
        try {
            Hashtable<EncodeHintType, Object> hints = new Hashtable<EncodeHintType, Object>();
            hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
            hints.put(EncodeHintType.MARGIN, 0);
            if (format.equals((Object)BarcodeFormat.QR_CODE)) {
                hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
            }
            BitMatrix matrix = new MultiFormatWriter().encode(data, format, w, h, hints);
            int width = matrix.getWidth();
            int height = matrix.getHeight();
            BufferedImage image = new BufferedImage(width, height, 2);
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    image.setRGB(x, y, matrix.get(x, y) ? -16777216 : -1);
                }
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "png", outputStream);
            byte[] bytes = outputStream.toByteArray();
            String base64Data = Base64Util.encodeToString((byte[])bytes);
            IOUtils.closeQuietly((OutputStream)outputStream);
            return new Image(base64Data, w, h);
        }
        catch (Exception ex) {
            throw new ReportComputeException(ex);
        }
    }

    public ValueType type() {
        return ValueType.zxing;
    }
}

