/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.console.importexcel;

import com.bstek.ureport.console.RenderPageServletAction;
import com.bstek.ureport.console.cache.TempObjectCache;
import com.bstek.ureport.console.importexcel.ExcelParser;
import com.bstek.ureport.console.importexcel.HSSFExcelParser;
import com.bstek.ureport.console.importexcel.XSSFExcelParser;
import com.bstek.ureport.definition.ReportDefinition;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.springblade.core.tool.utils.MultipartUtil;
import org.springframework.web.multipart.MultipartFile;

public class ImportExcelServletAction
extends RenderPageServletAction {
    private List<ExcelParser> excelParsers = new ArrayList<ExcelParser>();

    public ImportExcelServletAction() {
        this.excelParsers.add((ExcelParser)new HSSFExcelParser());
        this.excelParsers.add((ExcelParser)new XSSFExcelParser());
    }

    public void execute(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String errorInfo;
        ReportDefinition report = null;
        try {
            List items = MultipartUtil.extractMultipartFiles((HttpServletRequest)req);
            for (MultipartFile item : items) {
                String fieldName = item.getName();
                String name = Objects.requireNonNull(item.getOriginalFilename()).toLowerCase();
                if (!fieldName.equals("_excel_file") || !name.endsWith(".xls") && !name.endsWith(".xlsx")) continue;
                InputStream inputStream = item.getInputStream();
                for (ExcelParser parser : this.excelParsers) {
                    if (!parser.support(name)) continue;
                    report = parser.parse(inputStream);
                    break;
                }
                inputStream.close();
                break;
            }
            errorInfo = "\u8bf7\u9009\u62e9\u4e00\u4e2a\u5408\u6cd5\u7684Excel\u5bfc\u5165";
        }
        catch (Exception e) {
            e.printStackTrace();
            errorInfo = e.getMessage();
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (report != null) {
            result.put("result", true);
            TempObjectCache.putObject("classpath:template/template.ureport.xml", report);
        } else {
            result.put("result", false);
            if (errorInfo != null) {
                result.put("errorInfo", errorInfo);
            }
        }
        this.writeObjectToJson(resp, result);
    }

    public String url() {
        return "/import";
    }
}

