/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.font;

import com.bstek.ureport.exception.ReportComputeException;
import com.bstek.ureport.exception.ReportException;
import com.bstek.ureport.export.pdf.font.FontRegister;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Font;
import com.itextpdf.text.FontFactory;
import com.itextpdf.text.pdf.BaseFont;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class FontBuilder
implements ApplicationContextAware {
    private static ApplicationContext applicationContext;
    private static final Map<String, BaseFont> fontMap;
    public static final Map<String, String> fontPathMap;
    private static List<String> systemFontNameList;

    public static Font getFont(String fontName, int fontSize, boolean fontBold, boolean fontItalic, boolean underLine) {
        BaseFont baseFont = fontMap.get(fontName);
        Font font = null;
        font = baseFont != null ? new Font(baseFont) : FontFactory.getFont((String)fontName);
        font.setSize((float)fontSize);
        int fontStyle = 0;
        if (fontBold && fontItalic && underLine) {
            fontStyle = 7;
        } else if (fontBold) {
            fontStyle = fontItalic ? 3 : (underLine ? 5 : 1);
        } else if (fontItalic) {
            fontStyle = underLine ? 6 : (fontBold ? 3 : 2);
        } else if (underLine) {
            fontStyle = 4;
        }
        font.setStyle(fontStyle);
        return font;
    }

    public static java.awt.Font getAwtFont(String fontName, int fontStyle, float size) {
        java.awt.Font font;
        if (systemFontNameList.contains(fontName)) {
            return new java.awt.Font(fontName, fontStyle, Integer.parseInt(String.valueOf(size)));
        }
        String fontPath = fontPathMap.get(fontName);
        if (fontPath == null && (fontPath = fontPathMap.get(fontName = "\u5b8b\u4f53")) == null) {
            return null;
        }
        InputStream inputStream = null;
        try {
            inputStream = applicationContext.getResource(fontPath).getInputStream();
            java.awt.Font font2 = java.awt.Font.createFont(0, inputStream);
            font = font2.deriveFont(fontStyle, size);
        }
        catch (Exception e) {
            try {
                throw new ReportException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return font;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        String[] fontNames;
        FontBuilder.applicationContext = applicationContext;
        GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (String name : fontNames = environment.getAvailableFontFamilyNames()) {
            systemFontNameList.add(name);
        }
        Collection fontRegisters = applicationContext.getBeansOfType(FontRegister.class).values();
        for (FontRegister fontReg : fontRegisters) {
            String fontName = fontReg.getFontName();
            String fontPath = fontReg.getFontPath();
            if (StringUtils.isEmpty((CharSequence)fontPath) || StringUtils.isEmpty((CharSequence)fontName)) continue;
            try {
                BaseFont baseFont = this.getIdentityFont(fontName, fontPath, applicationContext);
                if (baseFont == null) {
                    throw new ReportComputeException("Font " + fontPath + " does not exist");
                }
                fontMap.put(fontName, baseFont);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ReportComputeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BaseFont getIdentityFont(String fontFamily, String fontPath, ApplicationContext applicationContext) throws DocumentException, IOException {
        if (!((String)fontPath).startsWith("classpath:")) {
            fontPath = "classpath:" + (String)fontPath;
        }
        Object fontName = fontPath;
        int lastSlashPos = ((String)fontPath).lastIndexOf("/");
        if (lastSlashPos != -1) {
            fontName = ((String)fontPath).substring(lastSlashPos + 1, ((String)fontPath).length());
        }
        if (((String)fontName).toLowerCase().endsWith(".ttc")) {
            fontName = (String)fontName + ",0";
        }
        try (InputStream inputStream = null;){
            fontPathMap.put(fontFamily, (String)fontPath);
            inputStream = applicationContext.getResource((String)fontPath).getInputStream();
            byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
            BaseFont baseFont = BaseFont.createFont((String)fontName, (String)"Identity-H", (boolean)true, (boolean)true, (byte[])bytes, null);
            baseFont.setSubset(true);
            BaseFont baseFont2 = baseFont;
            return baseFont2;
        }
    }

    static {
        fontMap = new HashMap<String, BaseFont>();
        fontPathMap = new HashMap<String, String>();
        systemFontNameList = new ArrayList<String>();
    }
}

