/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.provider.image;

import com.bstek.ureport.exception.ReportComputeException;
import com.bstek.ureport.provider.image.ImageProvider;
import jakarta.servlet.ServletContext;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.context.ServletContextAware;

public class DefaultImageProvider
implements ImageProvider,
ApplicationContextAware,
ServletContextAware {
    private ApplicationContext applicationContext;
    private String baseWebPath;

    public InputStream getImage(String path) {
        try {
            if (((String)path).startsWith("classpath:") || ((String)path).startsWith("/WEB-INF")) {
                return this.applicationContext.getResource((String)path).getInputStream();
            }
            path = this.baseWebPath + (String)path;
            return new FileInputStream((String)path);
        }
        catch (IOException e) {
            throw new ReportComputeException((Exception)e);
        }
    }

    public boolean support(String path) {
        if (path.startsWith("classpath:")) {
            return true;
        }
        return this.baseWebPath != null && (path.startsWith("/") || path.startsWith("/WEB-INF"));
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setServletContext(ServletContext servletContext) {
        this.baseWebPath = servletContext.getRealPath("/");
    }
}

