/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.report.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springblade.core.secure.utils.AuthUtil;
import org.springblade.core.tool.utils.WebUtil;

public class UReportAuthFilter
implements Filter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UReportAuthFilter.class);
    private static final List<String> STATIC_RESOURCE_EXTENSIONS = Arrays.asList(".js", ".css", ".png", ".jpg", ".jpeg", ".gif", ".ico", ".svg", ".woff", ".woff2", ".ttf", ".eot", ".map", ".html", ".htm");
    private static final String RESOURCE_PATH_PREFIX = "/ureport/res/ureport-asserts";
    private static final String SESSION_AUTH_KEY = "UREPORT_AUTHENTICATED";
    private static final String SESSION_USER_KEY = "UREPORT_USER_INFO";
    private static final String SESSION_USER_ID = "UREPORT_USER_ID";
    private static final Integer INTERVAL_TIME = 7200;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String requestURI = WebUtil.getRequestURI((HttpServletRequest)httpRequest);
        String requestIP = WebUtil.getIP((HttpServletRequest)httpRequest);
        if (this.isStaticResource(requestURI)) {
            chain.doFilter(request, response);
            return;
        }
        if (!this.isAuthenticatedWithSession(httpRequest)) {
            log.warn("\u672a\u6388\u6743\u8bbf\u95ee UReport API: {}, IP: {}", (Object)requestURI, (Object)requestIP);
            this.handleUnauthorized(httpResponse);
            return;
        }
        chain.doFilter(request, response);
    }

    private boolean isStaticResource(String requestURI) {
        if (requestURI.startsWith(RESOURCE_PATH_PREFIX)) {
            return true;
        }
        String lowerCaseURI = requestURI.toLowerCase();
        return STATIC_RESOURCE_EXTENSIONS.stream().anyMatch(lowerCaseURI::endsWith);
    }

    private boolean isAuthenticatedWithSession(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session != null && Boolean.TRUE.equals(session.getAttribute(SESSION_AUTH_KEY))) {
            log.debug("Session \u8ba4\u8bc1\u6709\u6548\uff0c\u7528\u6237: {}", session.getAttribute(SESSION_USER_KEY));
            return true;
        }
        if (this.isTokenAuthenticated(request)) {
            this.establishSession(request);
            log.info("Token \u8ba4\u8bc1\u6210\u529f\uff0c\u5df2\u5efa\u7acb Session \u4f1a\u8bdd");
            return true;
        }
        return false;
    }

    private boolean isTokenAuthenticated(HttpServletRequest request) {
        try {
            Long userId = AuthUtil.getUserId((HttpServletRequest)request);
            return userId != null && userId > 0L;
        }
        catch (Exception e) {
            log.debug("Token \u8ba4\u8bc1\u5931\u8d25: {}", (Object)e.getMessage());
            return false;
        }
    }

    private void establishSession(HttpServletRequest request) {
        HttpSession session = request.getSession(true);
        try {
            String userAccount = AuthUtil.getUserAccount((HttpServletRequest)request);
            Long userId = AuthUtil.getUserId((HttpServletRequest)request);
            session.setAttribute(SESSION_AUTH_KEY, (Object)true);
            session.setAttribute(SESSION_USER_KEY, (Object)userAccount);
            session.setAttribute(SESSION_USER_ID, (Object)userId);
            session.setMaxInactiveInterval(INTERVAL_TIME.intValue());
            log.debug("\u5efa\u7acb UReport \u8ba4\u8bc1\u4f1a\u8bdd: \u7528\u6237 {}, SessionID: {}", (Object)userAccount, (Object)session.getId());
        }
        catch (Exception e) {
            log.warn("\u5efa\u7acb\u8ba4\u8bc1\u4f1a\u8bdd\u5931\u8d25: {}", (Object)e.getMessage());
        }
    }

    private String getUserFromSession(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session != null) {
            Object userAccount = session.getAttribute(SESSION_USER_KEY);
            return userAccount != null ? userAccount.toString() : "\u672a\u77e5\u7528\u6237";
        }
        return "\u672a\u77e5\u7528\u6237";
    }

    private void handleUnauthorized(HttpServletResponse response) throws IOException {
        response.setStatus(401);
        response.setContentType("application/json;charset=UTF-8");
        response.setCharacterEncoding("UTF-8");
        try (PrintWriter writer = response.getWriter();){
            writer.write("\u8bbf\u95ee UReport \u9700\u8981 BladeX \u7684 Token \u8ba4\u8bc1");
            writer.flush();
        }
    }
}

