/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.sms.qiniu;

import com.qiniu.common.QiniuException;
import com.qiniu.http.Response;
import com.qiniu.sms.SmsManager;
import java.time.Duration;
import java.util.Collection;
import java.util.Date;
import org.springblade.core.redis.cache.BladeRedis;
import org.springblade.core.sms.SmsTemplate;
import org.springblade.core.sms.model.SmsCode;
import org.springblade.core.sms.model.SmsData;
import org.springblade.core.sms.model.SmsResponse;
import org.springblade.core.tool.utils.StringUtil;
import org.springframework.http.HttpStatus;

public class QiniuSmsTemplate
implements SmsTemplate {
    private final SmsManager smsManager;
    private final BladeRedis bladeRedis;

    public SmsResponse sendMessage(SmsData smsData, Collection<String> phones) {
        try {
            Response response = this.smsManager.sendMessage(smsData.getTemplateId(), StringUtil.toStringArray(phones), smsData.getParams());
            return new SmsResponse(response.isOK(), Integer.valueOf(response.statusCode), response.toString());
        }
        catch (QiniuException e) {
            e.printStackTrace();
            return new SmsResponse(Boolean.FALSE.booleanValue(), Integer.valueOf(HttpStatus.INTERNAL_SERVER_ERROR.value()), e.getMessage());
        }
    }

    public SmsCode sendValidate(SmsData smsData, String phone) {
        SmsCode smsCode = new SmsCode();
        boolean temp = this.sendSingle(smsData, phone);
        if (temp && StringUtil.isNotBlank((CharSequence)smsData.getKey())) {
            String id = StringUtil.randomUUID();
            String value = (String)smsData.getParams().get(smsData.getKey());
            this.bladeRedis.setEx("blade:sms::captcha:" + id, (Object)value, Duration.ofMinutes(30L));
            smsCode.setId(id).setValue(value);
        } else {
            smsCode.setSuccess(Boolean.FALSE.booleanValue());
        }
        return smsCode;
    }

    public boolean validateMessage(SmsCode smsCode) {
        String id = smsCode.getId();
        String value = smsCode.getValue();
        String cache = (String)this.bladeRedis.get("blade:sms::captcha:" + id);
        if (StringUtil.isNotBlank((CharSequence)value) && StringUtil.equalsIgnoreCase((CharSequence)cache, (CharSequence)value)) {
            this.bladeRedis.del("blade:sms::captcha:" + id);
            return true;
        }
        return false;
    }

    public Object queryLog(String phone, Date sendDate, Integer current, Integer size) {
        throw new RuntimeException("Not Implement");
    }

    public QiniuSmsTemplate(SmsManager smsManager, BladeRedis bladeRedis) {
        this.smsManager = smsManager;
        this.bladeRedis = bladeRedis;
    }
}

