/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.system.user.cache;

import org.springblade.core.cache.utils.CacheUtil;
import org.springblade.core.tool.api.R;
import org.springblade.core.tool.utils.Func;
import org.springblade.core.tool.utils.SpringUtil;
import org.springblade.core.tool.utils.StringUtil;
import org.springblade.system.user.entity.User;
import org.springblade.system.user.feign.IUserClient;

public class UserCache {
    private static final String USER_CACHE_ID = "user:id:";
    private static final String USER_CACHE_ACCOUNT = "user:account:";
    private static IUserClient userClient;

    private static IUserClient getUserClient() {
        if (userClient == null) {
            userClient = (IUserClient)SpringUtil.getBean(IUserClient.class);
        }
        return userClient;
    }

    public static User getUserByTaskUser(String taskUserId) {
        Long userId = Func.toLong((Object)StringUtil.removePrefix((CharSequence)taskUserId, (CharSequence)"taskUser_"));
        return UserCache.getUser(userId);
    }

    public static User getUser(Long userId) {
        return (User)((Object)CacheUtil.get((String)"blade:user", (String)USER_CACHE_ID, (Object)userId, () -> {
            R<User> result = UserCache.getUserClient().userInfoById(userId);
            return (User)((Object)((Object)result.getData()));
        }));
    }

    public static User getUser(String tenantId, String account) {
        return (User)((Object)CacheUtil.get((String)"blade:user", (String)USER_CACHE_ACCOUNT, (Object)(tenantId + "-" + account), () -> {
            R<User> result = UserCache.getUserClient().userByAccount(tenantId, account);
            return (User)((Object)((Object)result.getData()));
        }));
    }
}

