/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.system.user.feign;

import com.baomidou.mybatisplus.core.metadata.IPage;
import java.util.List;
import org.springblade.core.tool.api.R;
import org.springblade.system.user.entity.User;
import org.springblade.system.user.entity.UserInfo;
import org.springblade.system.user.entity.UserOauth;
import org.springblade.system.user.vo.UserVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value="blade-user")
public interface IUserClient {
    public static final String API_PREFIX = "/client";
    public static final String USER_INFO = "/client/user-info";
    public static final String USER_INFO_BY_TYPE = "/client/user-info-by-type";
    public static final String USER_INFO_BY_ID = "/client/user-info-by-id";
    public static final String USER_INFO_BY_ACCOUNT = "/client/user-info-by-account";
    public static final String USER_INFO_BY_MOBILE = "/client/user-info-by-mobile";
    public static final String USER_AUTH_INFO = "/client/user-auth-info";
    public static final String SAVE_USER = "/client/save-user";
    public static final String REMOVE_USER = "/client/remove-user";
    public static final String USER_PAGE = "/client/page";
    public static final String USER_LIST = "/client/list";
    public static final String USER_LIST_BY_TENANT = "/client/list-by-tenant";
    public static final String USER_DETAIL = "/client/detail";
    public static final String UPDATE_USER = "/client/update-user";
    public static final String REGISTER_USER = "/client/register-user";
    public static final String UPDATE_USER_PASSWORD = "/client/update-user-password";
    public static final String CHANGE_STATUS = "/client/change-status";
    public static final String LOGIN_SUCCESS = "/client/login-success";
    public static final String LOGIN_FAILURE = "/client/login-failure";
    public static final String USER_BY_IDS = "/client/list-by-ids";
    public static final String USER_BY_NAME = "/client/list-by-name";

    @GetMapping(value={"/client/user-info-by-id"})
    public R<User> userInfoById(@RequestParam(value="userId") Long var1);

    @GetMapping(value={"/client/user-info-by-account"})
    public R<User> userByAccount(@RequestParam(value="tenantId") String var1, @RequestParam(value="account") String var2);

    @GetMapping(value={"/client/user-info-by-mobile"})
    public R<UserInfo> userByMobile(@RequestParam(value="clientId") String var1, @RequestParam(value="tenantId") String var2, @RequestParam(value="mobile") String var3);

    @GetMapping(value={"/client/user-info"})
    public R<UserInfo> userInfo(@RequestParam(value="clientId") String var1, @RequestParam(value="tenantId") String var2, @RequestParam(value="account") String var3);

    @GetMapping(value={"/client/user-info-by-type"})
    public R<UserInfo> userInfo(@RequestParam(value="clientId") String var1, @RequestParam(value="tenantId") String var2, @RequestParam(value="account") String var3, @RequestParam(value="userType") String var4);

    @PostMapping(value={"/client/user-auth-info"})
    public R<UserInfo> userAuthInfo(@RequestBody UserOauth var1);

    @PostMapping(value={"/client/save-user"})
    public R<Boolean> saveUser(@RequestBody User var1);

    @PostMapping(value={"/client/remove-user"})
    public R<Boolean> removeUser(@RequestParam(value="tenantIds") String var1);

    @GetMapping(value={"/client/page"})
    public R<IPage<UserVO>> page(@SpringQueryMap User var1, @RequestParam Integer var2, @RequestParam Integer var3, @RequestParam(required=false) String var4, @RequestParam(required=false) String var5, @RequestParam(required=false) Long var6);

    @GetMapping(value={"/client/list"})
    public R<List<UserVO>> list(@SpringQueryMap User var1, @RequestParam(required=false) String var2, @RequestParam(required=false) String var3, @RequestParam(required=false) Long var4);

    @GetMapping(value={"/client/list-by-tenant"})
    public R<List<UserVO>> listByTenant(@SpringQueryMap User var1, @RequestParam(required=false) String var2, @RequestParam(required=false) String var3, @RequestParam(required=false) Long var4, @RequestParam String var5);

    @GetMapping(value={"/client/detail"})
    public R<UserVO> detail(@RequestParam String var1, @RequestParam Long var2);

    @PutMapping(value={"/client/update-user"})
    public R<Boolean> updateUser(@RequestBody User var1);

    @PostMapping(value={"/client/register-user"})
    public R<User> registerUser(@RequestBody User var1);

    @PutMapping(value={"/client/update-user-password"})
    public R<Boolean> updateUserPassword(@RequestBody User var1);

    @PutMapping(value={"/client/change-status"})
    public R<Boolean> changeStatus(@RequestParam String var1, @RequestParam Integer var2);

    @PutMapping(value={"/client/login-success"})
    public R<Boolean> loginSuccess(@RequestParam Long var1, @RequestParam String var2);

    @PutMapping(value={"/client/login-failure"})
    public R<Boolean> loginFailure(@RequestParam String var1, @RequestParam String var2, @RequestParam String var3);

    @PutMapping(value={"/client/list-by-ids"})
    public R<List<User>> userByIds(@RequestBody List<Long> var1);

    @PutMapping(value={"/client/list-by-name"})
    public R<List<User>> userByName(@RequestParam(value="name") String var1);
}

