/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core;

import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.servers.Server;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.SpringDocConfigProperties;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.springframework.util.CollectionUtils;

public class PropertyResolverUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertyResolverUtils.class);
    private final ConfigurableBeanFactory factory;
    private final MessageSource messageSource;
    private final SpringDocConfigProperties springDocConfigProperties;

    public PropertyResolverUtils(ConfigurableBeanFactory factory, MessageSource messageSource, SpringDocConfigProperties springDocConfigProperties) {
        this.factory = factory;
        this.messageSource = messageSource;
        this.springDocConfigProperties = springDocConfigProperties;
    }

    public String resolve(String parameterProperty, Locale locale) {
        String result = parameterProperty;
        if (parameterProperty != null) {
            if (!this.springDocConfigProperties.isDisableI18n()) {
                try {
                    result = this.messageSource.getMessage(parameterProperty, null, locale);
                }
                catch (NoSuchMessageException ex) {
                    LOGGER.trace(ex.getMessage());
                }
            }
            if (parameterProperty.equals(result)) {
                try {
                    result = this.factory.resolveEmbeddedValue(parameterProperty);
                }
                catch (IllegalArgumentException ex) {
                    LOGGER.warn(ex.getMessage());
                }
            }
        }
        return result;
    }

    public List<Server> resolveProperties(List<Server> servers, Locale locale) {
        servers.forEach(server -> {
            this.resolveProperty(() -> ((Server)server).getUrl(), arg_0 -> ((Server)server).url(arg_0), this, locale);
            this.resolveProperty(() -> ((Server)server).getDescription(), arg_0 -> ((Server)server).description(arg_0), this, locale);
            if (CollectionUtils.isEmpty((Map)server.getVariables())) {
                server.setVariables(null);
            }
        });
        return servers;
    }

    public Info resolveProperties(Info info, Locale locale) {
        Contact contact;
        this.resolveProperty(() -> ((Info)info).getTitle(), arg_0 -> ((Info)info).title(arg_0), this, locale);
        this.resolveProperty(() -> ((Info)info).getDescription(), arg_0 -> ((Info)info).description(arg_0), this, locale);
        this.resolveProperty(() -> ((Info)info).getVersion(), arg_0 -> ((Info)info).version(arg_0), this, locale);
        this.resolveProperty(() -> ((Info)info).getTermsOfService(), arg_0 -> ((Info)info).termsOfService(arg_0), this, locale);
        License license = info.getLicense();
        if (license != null) {
            this.resolveProperty(() -> ((License)license).getName(), arg_0 -> ((License)license).name(arg_0), this, locale);
            this.resolveProperty(() -> ((License)license).getUrl(), arg_0 -> ((License)license).url(arg_0), this, locale);
        }
        if ((contact = info.getContact()) != null) {
            this.resolveProperty(() -> ((Contact)contact).getName(), arg_0 -> ((Contact)contact).name(arg_0), this, locale);
            this.resolveProperty(() -> ((Contact)contact).getEmail(), arg_0 -> ((Contact)contact).email(arg_0), this, locale);
            this.resolveProperty(() -> ((Contact)contact).getUrl(), arg_0 -> ((Contact)contact).url(arg_0), this, locale);
        }
        return info;
    }

    public Schema resolveProperties(Schema<?> schema, Locale locale) {
        this.resolveProperty(() -> schema.getName(), arg_0 -> schema.name(arg_0), this, locale);
        this.resolveProperty(() -> schema.getTitle(), arg_0 -> schema.title(arg_0), this, locale);
        this.resolveProperty(() -> schema.getDescription(), arg_0 -> schema.description(arg_0), this, locale);
        Map properties = schema.getProperties();
        if (!CollectionUtils.isEmpty((Map)properties)) {
            LinkedHashMap resolvedSchemas = properties.entrySet().stream().map(es -> {
                es.setValue(this.resolveProperties((Schema)es.getValue(), locale));
                return es;
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e2, LinkedHashMap::new));
            schema.setProperties((Map)resolvedSchemas);
        }
        return schema;
    }

    private void resolveProperty(Supplier<String> getProperty, Consumer<String> setProperty, PropertyResolverUtils propertyResolverUtils, Locale locale) {
        String value = getProperty.get();
        if (StringUtils.isNotBlank((CharSequence)value)) {
            setProperty.accept(propertyResolverUtils.resolve(value, locale));
        }
    }

    public ConfigurableBeanFactory getFactory() {
        return this.factory;
    }

    public SpringDocConfigProperties getSpringDocConfigProperties() {
        return this.springDocConfigProperties;
    }
}

