/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.openai.api;

import java.util.ArrayList;
import java.util.List;
import org.springframework.ai.openai.api.OpenAiApi;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class OpenAiStreamFunctionCallingHelper {
    public OpenAiApi.ChatCompletionChunk merge(OpenAiApi.ChatCompletionChunk previous, OpenAiApi.ChatCompletionChunk current) {
        if (previous == null) {
            return current;
        }
        String id = current.id() != null ? current.id() : previous.id();
        Long created = current.created() != null ? current.created() : previous.created();
        String model = current.model() != null ? current.model() : previous.model();
        String serviceTier = current.serviceTier() != null ? current.serviceTier() : previous.serviceTier();
        String systemFingerprint = current.systemFingerprint() != null ? current.systemFingerprint() : previous.systemFingerprint();
        String object = current.object() != null ? current.object() : previous.object();
        OpenAiApi.Usage usage = current.usage() != null ? current.usage() : previous.usage();
        OpenAiApi.ChatCompletionChunk.ChunkChoice previousChoice0 = CollectionUtils.isEmpty(previous.choices()) ? null : previous.choices().get(0);
        OpenAiApi.ChatCompletionChunk.ChunkChoice currentChoice0 = CollectionUtils.isEmpty(current.choices()) ? null : current.choices().get(0);
        OpenAiApi.ChatCompletionChunk.ChunkChoice choice = this.merge(previousChoice0, currentChoice0);
        List<OpenAiApi.ChatCompletionChunk.ChunkChoice> chunkChoices = choice == null ? List.of() : List.of(choice);
        return new OpenAiApi.ChatCompletionChunk(id, chunkChoices, created, model, serviceTier, systemFingerprint, object, usage);
    }

    private OpenAiApi.ChatCompletionChunk.ChunkChoice merge(OpenAiApi.ChatCompletionChunk.ChunkChoice previous, OpenAiApi.ChatCompletionChunk.ChunkChoice current) {
        if (previous == null) {
            return current;
        }
        OpenAiApi.ChatCompletionFinishReason finishReason = current.finishReason() != null ? current.finishReason() : previous.finishReason();
        Integer index = current.index() != null ? current.index() : previous.index();
        OpenAiApi.ChatCompletionMessage message = this.merge(previous.delta(), current.delta());
        OpenAiApi.LogProbs logprobs = current.logprobs() != null ? current.logprobs() : previous.logprobs();
        return new OpenAiApi.ChatCompletionChunk.ChunkChoice(finishReason, index, message, logprobs);
    }

    private OpenAiApi.ChatCompletionMessage merge(OpenAiApi.ChatCompletionMessage previous, OpenAiApi.ChatCompletionMessage current) {
        String content = current.content() != null ? current.content() : (previous.content() != null ? previous.content() : "");
        OpenAiApi.ChatCompletionMessage.Role role = current.role() != null ? current.role() : previous.role();
        role = role != null ? role : OpenAiApi.ChatCompletionMessage.Role.ASSISTANT;
        String name = current.name() != null ? current.name() : previous.name();
        String toolCallId = current.toolCallId() != null ? current.toolCallId() : previous.toolCallId();
        String refusal = current.refusal() != null ? current.refusal() : previous.refusal();
        OpenAiApi.ChatCompletionMessage.AudioOutput audioOutput = current.audioOutput() != null ? current.audioOutput() : previous.audioOutput();
        List<OpenAiApi.ChatCompletionMessage.Annotation> annotations = current.annotations() != null ? current.annotations() : previous.annotations();
        ArrayList<OpenAiApi.ChatCompletionMessage.ToolCall> toolCalls = new ArrayList<OpenAiApi.ChatCompletionMessage.ToolCall>();
        OpenAiApi.ChatCompletionMessage.ToolCall lastPreviousTooCall = null;
        if (previous.toolCalls() != null) {
            lastPreviousTooCall = previous.toolCalls().get(previous.toolCalls().size() - 1);
            if (previous.toolCalls().size() > 1) {
                toolCalls.addAll(previous.toolCalls().subList(0, previous.toolCalls().size() - 1));
            }
        }
        if (current.toolCalls() != null) {
            if (current.toolCalls().size() > 1) {
                throw new IllegalStateException("Currently only one tool call is supported per message!");
            }
            OpenAiApi.ChatCompletionMessage.ToolCall currentToolCall = current.toolCalls().iterator().next();
            if (StringUtils.hasText((String)currentToolCall.id())) {
                if (lastPreviousTooCall != null) {
                    toolCalls.add(lastPreviousTooCall);
                }
                toolCalls.add(currentToolCall);
            } else {
                toolCalls.add(this.merge(lastPreviousTooCall, currentToolCall));
            }
        } else if (lastPreviousTooCall != null) {
            toolCalls.add(lastPreviousTooCall);
        }
        return new OpenAiApi.ChatCompletionMessage(content, role, name, toolCallId, toolCalls, refusal, audioOutput, annotations);
    }

    private OpenAiApi.ChatCompletionMessage.ToolCall merge(OpenAiApi.ChatCompletionMessage.ToolCall previous, OpenAiApi.ChatCompletionMessage.ToolCall current) {
        if (previous == null) {
            return current;
        }
        String id = StringUtils.hasText((String)current.id()) ? current.id() : previous.id();
        String type = current.type() != null ? current.type() : previous.type();
        OpenAiApi.ChatCompletionMessage.ChatCompletionFunction function = this.merge(previous.function(), current.function());
        return new OpenAiApi.ChatCompletionMessage.ToolCall(id, type, function);
    }

    private OpenAiApi.ChatCompletionMessage.ChatCompletionFunction merge(OpenAiApi.ChatCompletionMessage.ChatCompletionFunction previous, OpenAiApi.ChatCompletionMessage.ChatCompletionFunction current) {
        if (previous == null) {
            return current;
        }
        String name = StringUtils.hasText((String)current.name()) ? current.name() : previous.name();
        StringBuilder arguments = new StringBuilder();
        if (previous.arguments() != null) {
            arguments.append(previous.arguments());
        }
        if (current.arguments() != null) {
            arguments.append(current.arguments());
        }
        return new OpenAiApi.ChatCompletionMessage.ChatCompletionFunction(name, arguments.toString());
    }

    public boolean isStreamingToolFunctionCall(OpenAiApi.ChatCompletionChunk chatCompletion) {
        if (chatCompletion == null || CollectionUtils.isEmpty(chatCompletion.choices())) {
            return false;
        }
        OpenAiApi.ChatCompletionChunk.ChunkChoice choice = chatCompletion.choices().get(0);
        if (choice == null || choice.delta() == null) {
            return false;
        }
        return !CollectionUtils.isEmpty(choice.delta().toolCalls());
    }

    public boolean isStreamingToolFunctionCallFinish(OpenAiApi.ChatCompletionChunk chatCompletion) {
        if (chatCompletion == null || CollectionUtils.isEmpty(chatCompletion.choices())) {
            return false;
        }
        OpenAiApi.ChatCompletionChunk.ChunkChoice choice = chatCompletion.choices().get(0);
        if (choice == null || choice.delta() == null) {
            return false;
        }
        return choice.finishReason() == OpenAiApi.ChatCompletionFinishReason.TOOL_CALLS;
    }

    public OpenAiApi.ChatCompletion chunkToChatCompletion(OpenAiApi.ChatCompletionChunk chunk) {
        List<OpenAiApi.ChatCompletion.Choice> choices = chunk.choices().stream().map(chunkChoice -> new OpenAiApi.ChatCompletion.Choice(chunkChoice.finishReason(), chunkChoice.index(), chunkChoice.delta(), chunkChoice.logprobs())).toList();
        return new OpenAiApi.ChatCompletion(chunk.id(), choices, chunk.created(), chunk.model(), chunk.serviceTier(), chunk.systemFingerprint(), "chat.completion", null);
    }
}

