/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.support;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.springframework.amqp.core.MessageDeliveryMode;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.support.AmqpHeaderMapper;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.support.AbstractHeaderMapper;
import org.springframework.util.StringUtils;

public class SimpleAmqpHeaderMapper
extends AbstractHeaderMapper<MessageProperties>
implements AmqpHeaderMapper {
    public void fromHeaders(MessageHeaders headers, MessageProperties amqpMessageProperties) {
        String replyToStack;
        String replyCorrelation;
        String userId;
        String type;
        Date timestamp;
        String replyTo;
        Boolean redelivered;
        String receivedRoutingKey;
        String receivedExchange;
        Integer priority;
        String messageId;
        Integer messageCount;
        String expiration;
        Long deliveryTag;
        MessageDeliveryMode deliveryMode;
        Object correlationId;
        String contentType;
        Long contentLength;
        String contentEncoding;
        String clusterId;
        String appId = (String)this.getHeaderIfAvailable((Map)headers, "amqp_appId", String.class);
        if (StringUtils.hasText((String)appId)) {
            amqpMessageProperties.setAppId(appId);
        }
        if (StringUtils.hasText((String)(clusterId = (String)this.getHeaderIfAvailable((Map)headers, "amqp_clusterId", String.class)))) {
            amqpMessageProperties.setClusterId(clusterId);
        }
        if (StringUtils.hasText((String)(contentEncoding = (String)this.getHeaderIfAvailable((Map)headers, "amqp_contentEncoding", String.class)))) {
            amqpMessageProperties.setContentEncoding(contentEncoding);
        }
        if ((contentLength = (Long)this.getHeaderIfAvailable((Map)headers, "amqp_contentLength", Long.class)) != null) {
            amqpMessageProperties.setContentLength(contentLength);
        }
        if (StringUtils.hasText((String)(contentType = this.extractContentTypeAsString((Map<String, Object>)headers)))) {
            amqpMessageProperties.setContentType(contentType);
        }
        if ((correlationId = headers.get((Object)"amqp_correlationId")) instanceof byte[]) {
            amqpMessageProperties.setCorrelationId((byte[])correlationId);
        }
        if ((deliveryMode = (MessageDeliveryMode)((Object)this.getHeaderIfAvailable((Map)headers, "amqp_deliveryMode", MessageDeliveryMode.class))) != null) {
            amqpMessageProperties.setDeliveryMode(deliveryMode);
        }
        if ((deliveryTag = (Long)this.getHeaderIfAvailable((Map)headers, "amqp_deliveryTag", Long.class)) != null) {
            amqpMessageProperties.setDeliveryTag(deliveryTag);
        }
        if (StringUtils.hasText((String)(expiration = (String)this.getHeaderIfAvailable((Map)headers, "amqp_expiration", String.class)))) {
            amqpMessageProperties.setExpiration(expiration);
        }
        if ((messageCount = (Integer)this.getHeaderIfAvailable((Map)headers, "amqp_messageCount", Integer.class)) != null) {
            amqpMessageProperties.setMessageCount(messageCount);
        }
        if (StringUtils.hasText((String)(messageId = (String)this.getHeaderIfAvailable((Map)headers, "amqp_messageId", String.class)))) {
            amqpMessageProperties.setMessageId(messageId);
        }
        if ((priority = (Integer)this.getHeaderIfAvailable((Map)headers, "priority", Integer.class)) != null) {
            amqpMessageProperties.setPriority(priority);
        }
        if (StringUtils.hasText((String)(receivedExchange = (String)this.getHeaderIfAvailable((Map)headers, "amqp_receivedExchange", String.class)))) {
            amqpMessageProperties.setReceivedExchange(receivedExchange);
        }
        if (StringUtils.hasText((String)(receivedRoutingKey = (String)this.getHeaderIfAvailable((Map)headers, "amqp_receivedRoutingKey", String.class)))) {
            amqpMessageProperties.setReceivedRoutingKey(receivedRoutingKey);
        }
        if ((redelivered = (Boolean)this.getHeaderIfAvailable((Map)headers, "amqp_redelivered", Boolean.class)) != null) {
            amqpMessageProperties.setRedelivered(redelivered);
        }
        if ((replyTo = (String)this.getHeaderIfAvailable((Map)headers, "amqp_replyTo", String.class)) != null) {
            amqpMessageProperties.setReplyTo(replyTo);
        }
        if ((timestamp = (Date)this.getHeaderIfAvailable((Map)headers, "amqp_timestamp", Date.class)) != null) {
            amqpMessageProperties.setTimestamp(timestamp);
        }
        if ((type = (String)this.getHeaderIfAvailable((Map)headers, "amqp_type", String.class)) != null) {
            amqpMessageProperties.setType(type);
        }
        if (StringUtils.hasText((String)(userId = (String)this.getHeaderIfAvailable((Map)headers, "amqp_userId", String.class)))) {
            amqpMessageProperties.setUserId(userId);
        }
        if (StringUtils.hasLength((String)(replyCorrelation = (String)this.getHeaderIfAvailable((Map)headers, "amqp_springReplyCorrelation", String.class)))) {
            amqpMessageProperties.setHeader("spring_reply_correlation", replyCorrelation);
        }
        if (StringUtils.hasLength((String)(replyToStack = (String)this.getHeaderIfAvailable((Map)headers, "amqp_springReplyToStack", String.class)))) {
            amqpMessageProperties.setHeader("spring_reply_to", replyToStack);
        }
        for (Map.Entry entry : headers.entrySet()) {
            Object value;
            String headerName = (String)entry.getKey();
            if (!StringUtils.hasText((String)headerName) || headerName.startsWith("amqp_") || (value = entry.getValue()) == null) continue;
            String propertyName = this.fromHeaderName(headerName);
            if (amqpMessageProperties.getHeaders().containsKey(headerName)) continue;
            amqpMessageProperties.setHeader(propertyName, value);
        }
    }

    public MessageHeaders toHeaders(MessageProperties amqpMessageProperties) {
        HashMap<String, Object> headers;
        block22: {
            headers = new HashMap<String, Object>();
            try {
                String userId;
                String type;
                Date timestamp;
                String replyTo;
                Boolean redelivered;
                String receivedRoutingKey;
                String receivedExchange;
                Integer priority;
                String messageId;
                Integer messageCount;
                String expiration;
                long deliveryTag;
                MessageDeliveryMode deliveryMode;
                byte[] correlationId;
                String contentType;
                long contentLength;
                String contentEncoding;
                String clusterId;
                String appId = amqpMessageProperties.getAppId();
                if (StringUtils.hasText((String)appId)) {
                    headers.put("amqp_appId", appId);
                }
                if (StringUtils.hasText((String)(clusterId = amqpMessageProperties.getClusterId()))) {
                    headers.put("amqp_clusterId", clusterId);
                }
                if (StringUtils.hasText((String)(contentEncoding = amqpMessageProperties.getContentEncoding()))) {
                    headers.put("amqp_contentEncoding", contentEncoding);
                }
                if ((contentLength = amqpMessageProperties.getContentLength()) > 0L) {
                    headers.put("amqp_contentLength", contentLength);
                }
                if (StringUtils.hasText((String)(contentType = amqpMessageProperties.getContentType()))) {
                    headers.put("contentType", contentType);
                }
                if ((correlationId = amqpMessageProperties.getCorrelationId()) != null && correlationId.length > 0) {
                    headers.put("amqp_correlationId", correlationId);
                }
                if ((deliveryMode = amqpMessageProperties.getDeliveryMode()) != null) {
                    headers.put("amqp_deliveryMode", (Object)deliveryMode);
                }
                if ((deliveryTag = amqpMessageProperties.getDeliveryTag()) > 0L) {
                    headers.put("amqp_deliveryTag", deliveryTag);
                }
                if (StringUtils.hasText((String)(expiration = amqpMessageProperties.getExpiration()))) {
                    headers.put("amqp_expiration", expiration);
                }
                if ((messageCount = amqpMessageProperties.getMessageCount()) != null && messageCount > 0) {
                    headers.put("amqp_messageCount", messageCount);
                }
                if (StringUtils.hasText((String)(messageId = amqpMessageProperties.getMessageId()))) {
                    headers.put("amqp_messageId", messageId);
                }
                if ((priority = amqpMessageProperties.getPriority()) != null && priority > 0) {
                    headers.put("priority", priority);
                }
                if (StringUtils.hasText((String)(receivedExchange = amqpMessageProperties.getReceivedExchange()))) {
                    headers.put("amqp_receivedExchange", receivedExchange);
                }
                if (StringUtils.hasText((String)(receivedRoutingKey = amqpMessageProperties.getReceivedRoutingKey()))) {
                    headers.put("amqp_receivedRoutingKey", receivedRoutingKey);
                }
                if ((redelivered = amqpMessageProperties.isRedelivered()) != null) {
                    headers.put("amqp_redelivered", redelivered);
                }
                if ((replyTo = amqpMessageProperties.getReplyTo()) != null) {
                    headers.put("amqp_replyTo", replyTo);
                }
                if ((timestamp = amqpMessageProperties.getTimestamp()) != null) {
                    headers.put("amqp_timestamp", timestamp);
                }
                if (StringUtils.hasText((String)(type = amqpMessageProperties.getType()))) {
                    headers.put("amqp_type", type);
                }
                if (StringUtils.hasText((String)(userId = amqpMessageProperties.getUserId()))) {
                    headers.put("amqp_userId", userId);
                }
                for (Map.Entry<String, Object> entry : amqpMessageProperties.getHeaders().entrySet()) {
                    headers.put(entry.getKey(), entry.getValue());
                }
            }
            catch (Exception e) {
                if (!this.logger.isWarnEnabled()) break block22;
                this.logger.warn((Object)"error occurred while mapping from AMQP properties to MessageHeaders", (Throwable)e);
            }
        }
        return new MessageHeaders(headers);
    }

    private String extractContentTypeAsString(Map<String, Object> headers) {
        String contentTypeStringValue = null;
        Object contentType = this.getHeaderIfAvailable(headers, "contentType", Object.class);
        if (contentType != null) {
            String contentTypeClassName = contentType.getClass().getName();
            if (contentTypeClassName.equals("org.springframework.http.MediaType")) {
                contentTypeStringValue = contentType.toString();
            } else if (contentType instanceof String) {
                contentTypeStringValue = (String)contentType;
            } else if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("skipping header 'contentType' since it is not of expected type [" + contentTypeClassName + "]"));
            }
        }
        return contentTypeStringValue;
    }
}

