/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.support.postprocessor;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.springframework.amqp.support.postprocessor.AbstractDeflaterPostProcessor;

public class ZipPostProcessor
extends AbstractDeflaterPostProcessor {
    public ZipPostProcessor() {
    }

    public ZipPostProcessor(boolean autoDecompress) {
        super(autoDecompress);
    }

    @Override
    protected OutputStream getCompressorStream(OutputStream zipped) throws IOException {
        SettableLevelZipOutputStream zipper = new SettableLevelZipOutputStream(zipped, this.getLevel());
        zipper.putNextEntry(new ZipEntry("amqp"));
        return zipper;
    }

    @Override
    protected String getEncoding() {
        return "zip";
    }

    private static final class SettableLevelZipOutputStream
    extends ZipOutputStream {
        SettableLevelZipOutputStream(OutputStream zipped, int level) {
            super(zipped);
            this.setLevel(level);
        }
    }
}

