/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics.export.wavefront;

import com.wavefront.sdk.common.WavefrontSender;
import com.wavefront.sdk.common.clients.WavefrontClient;
import io.micrometer.core.instrument.Clock;
import io.micrometer.wavefront.WavefrontConfig;
import io.micrometer.wavefront.WavefrontMeterRegistry;
import java.time.Duration;
import org.springframework.boot.actuate.autoconfigure.metrics.CompositeMeterRegistryAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.export.wavefront.WavefrontProperties;
import org.springframework.boot.actuate.autoconfigure.metrics.export.wavefront.WavefrontPropertiesConfigAdapter;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.unit.DataSize;

@Configuration(proxyBeanMethods=false)
@AutoConfigureBefore(value={CompositeMeterRegistryAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class})
@AutoConfigureAfter(value={MetricsAutoConfiguration.class})
@ConditionalOnBean(value={Clock.class})
@ConditionalOnClass(value={WavefrontMeterRegistry.class, WavefrontSender.class})
@ConditionalOnProperty(prefix="management.metrics.export.wavefront", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={WavefrontProperties.class})
public class WavefrontMetricsExportAutoConfiguration {
    private final WavefrontProperties properties;

    public WavefrontMetricsExportAutoConfiguration(WavefrontProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    public WavefrontConfig wavefrontConfig() {
        return new WavefrontPropertiesConfigAdapter(this.properties);
    }

    @Bean
    @ConditionalOnMissingBean
    public WavefrontSender wavefrontSender(WavefrontConfig wavefrontConfig) {
        return this.createWavefrontSender(wavefrontConfig);
    }

    @Bean
    @ConditionalOnMissingBean
    public WavefrontMeterRegistry wavefrontMeterRegistry(WavefrontConfig wavefrontConfig, Clock clock, WavefrontSender wavefrontSender) {
        return WavefrontMeterRegistry.builder((WavefrontConfig)wavefrontConfig).clock(clock).wavefrontSender(wavefrontSender).build();
    }

    private WavefrontSender createWavefrontSender(WavefrontConfig wavefrontConfig) {
        WavefrontClient.Builder builder = WavefrontMeterRegistry.getDefaultSenderBuilder((WavefrontConfig)wavefrontConfig);
        PropertyMapper mapper = PropertyMapper.get().alwaysApplyingWhenNonNull();
        WavefrontProperties.Sender sender = this.properties.getSender();
        mapper.from((Object)sender.getMaxQueueSize()).to(arg_0 -> ((WavefrontClient.Builder)builder).maxQueueSize(arg_0));
        mapper.from((Object)sender.getFlushInterval()).asInt(Duration::getSeconds).to(arg_0 -> ((WavefrontClient.Builder)builder).flushIntervalSeconds(arg_0));
        mapper.from((Object)sender.getMessageSize()).asInt(DataSize::toBytes).to(arg_0 -> ((WavefrontClient.Builder)builder).messageSizeBytes(arg_0));
        return builder.build();
    }
}

