/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.info;

import org.springframework.boot.actuate.autoconfigure.info.ConditionalOnEnabledInfoContributor;
import org.springframework.boot.actuate.autoconfigure.info.InfoContributorFallback;
import org.springframework.boot.actuate.autoconfigure.info.InfoContributorProperties;
import org.springframework.boot.actuate.info.BuildInfoContributor;
import org.springframework.boot.actuate.info.EnvironmentInfoContributor;
import org.springframework.boot.actuate.info.GitInfoContributor;
import org.springframework.boot.actuate.info.InfoContributor;
import org.springframework.boot.actuate.info.JavaInfoContributor;
import org.springframework.boot.actuate.info.OsInfoContributor;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.autoconfigure.info.ProjectInfoAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.info.BuildProperties;
import org.springframework.boot.info.GitProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;

@AutoConfiguration(after={ProjectInfoAutoConfiguration.class})
@EnableConfigurationProperties(value={InfoContributorProperties.class})
public class InfoContributorAutoConfiguration {
    public static final int DEFAULT_ORDER = -2147483638;

    @Bean
    @ConditionalOnEnabledInfoContributor(value="env", fallback=InfoContributorFallback.DISABLE)
    @Order(value=-2147483638)
    public EnvironmentInfoContributor envInfoContributor(ConfigurableEnvironment environment) {
        return new EnvironmentInfoContributor(environment);
    }

    @Bean
    @ConditionalOnEnabledInfoContributor(value="git")
    @ConditionalOnSingleCandidate(value=GitProperties.class)
    @ConditionalOnMissingBean
    @Order(value=-2147483638)
    public GitInfoContributor gitInfoContributor(GitProperties gitProperties, InfoContributorProperties infoContributorProperties) {
        return new GitInfoContributor(gitProperties, infoContributorProperties.getGit().getMode());
    }

    @Bean
    @ConditionalOnEnabledInfoContributor(value="build")
    @ConditionalOnSingleCandidate(value=BuildProperties.class)
    @Order(value=-2147483638)
    public InfoContributor buildInfoContributor(BuildProperties buildProperties) {
        return new BuildInfoContributor(buildProperties);
    }

    @Bean
    @ConditionalOnEnabledInfoContributor(value="java", fallback=InfoContributorFallback.DISABLE)
    @Order(value=-2147483638)
    public JavaInfoContributor javaInfoContributor() {
        return new JavaInfoContributor();
    }

    @Bean
    @ConditionalOnEnabledInfoContributor(value="os", fallback=InfoContributorFallback.DISABLE)
    @Order(value=-2147483638)
    public OsInfoContributor osInfoContributor() {
        return new OsInfoContributor();
    }
}

