/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.health;

import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.function.Function;
import org.springframework.beans.BeanUtils;
import org.springframework.core.ResolvableType;
import org.springframework.util.Assert;

public abstract class AbstractCompositeHealthContributorConfiguration<C, I extends C, B> {
    private final Function<B, I> indicatorFactory;

    @Deprecated(since="3.0.0", forRemoval=true)
    protected AbstractCompositeHealthContributorConfiguration() {
        this.indicatorFactory = new ReflectionIndicatorFactory(ResolvableType.forClass(AbstractCompositeHealthContributorConfiguration.class, this.getClass()));
    }

    protected AbstractCompositeHealthContributorConfiguration(Function<B, I> indicatorFactory) {
        this.indicatorFactory = indicatorFactory;
    }

    protected final C createContributor(Map<String, B> beans) {
        Assert.notEmpty(beans, (String)"Beans must not be empty");
        if (beans.size() == 1) {
            return (C)this.createIndicator(beans.values().iterator().next());
        }
        return this.createComposite(beans);
    }

    protected abstract C createComposite(Map<String, B> var1);

    protected I createIndicator(B bean) {
        return this.indicatorFactory.apply(bean);
    }

    private class ReflectionIndicatorFactory
    implements Function<B, I> {
        private final Class<?> indicatorType;
        private final Class<?> beanType;

        ReflectionIndicatorFactory(ResolvableType type) {
            this.indicatorType = type.resolveGeneric(new int[]{1});
            this.beanType = type.resolveGeneric(new int[]{2});
        }

        @Override
        public I apply(B bean) {
            try {
                return BeanUtils.instantiateClass(this.getConstructor(), (Object[])new Object[]{bean});
            }
            catch (Exception ex) {
                throw new IllegalStateException("Unable to create health indicator %s for bean type %s".formatted(this.indicatorType, this.beanType), ex);
            }
        }

        private Constructor<I> getConstructor() throws NoSuchMethodException {
            return this.indicatorType.getDeclaredConstructor(this.beanType);
        }
    }
}

