/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.MigrationState;
import org.flywaydb.core.api.MigrationType;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.Assert;

@ConfigurationProperties(prefix="endpoints.flyway", ignoreUnknownFields=true)
public class FlywayEndpoint
extends AbstractEndpoint<List<FlywayMigration>> {
    private final Flyway flyway;

    public FlywayEndpoint(Flyway flyway) {
        super("flyway");
        Assert.notNull((Object)flyway, (String)"Flyway must not be null");
        this.flyway = flyway;
    }

    @Override
    public List<FlywayMigration> invoke() {
        ArrayList<FlywayMigration> migrations = new ArrayList<FlywayMigration>();
        for (MigrationInfo info : this.flyway.info().all()) {
            migrations.add(new FlywayMigration(info));
        }
        return migrations;
    }

    public static class FlywayMigration {
        private MigrationType type;
        private Integer checksum;
        private String version;
        private String description;
        private String script;
        private MigrationState state;
        private Date installedOn;
        private Integer executionTime;

        public FlywayMigration(MigrationInfo info) {
            this.type = info.getType();
            this.checksum = info.getChecksum();
            this.version = info.getVersion().toString();
            this.description = info.getDescription();
            this.script = info.getScript();
            this.state = info.getState();
            this.installedOn = info.getInstalledOn();
            this.executionTime = info.getExecutionTime();
        }

        public MigrationType getType() {
            return this.type;
        }

        public Integer getChecksum() {
            return this.checksum;
        }

        public String getVersion() {
            return this.version;
        }

        public String getDescription() {
            return this.description;
        }

        public String getScript() {
            return this.script;
        }

        public MigrationState getState() {
            return this.state;
        }

        public Date getInstalledOn() {
            return this.installedOn;
        }

        public Integer getExecutionTime() {
            return this.executionTime;
        }
    }
}

