/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.export.prometheus;

import io.prometheus.metrics.expositionformats.ExpositionFormats;
import io.prometheus.metrics.model.snapshots.MetricSnapshots;
import java.io.IOException;
import java.io.OutputStream;
import org.springframework.boot.actuate.endpoint.Producible;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum PrometheusOutputFormat implements Producible<PrometheusOutputFormat>
{
    CONTENT_TYPE_004("text/plain; version=0.0.4; charset=utf-8"){

        @Override
        void write(ExpositionFormats expositionFormats, OutputStream outputStream, MetricSnapshots snapshots) throws IOException {
            expositionFormats.getPrometheusTextFormatWriter().write(outputStream, snapshots);
        }

        @Override
        public boolean isDefault() {
            return true;
        }
    }
    ,
    CONTENT_TYPE_OPENMETRICS_100("application/openmetrics-text; version=1.0.0; charset=utf-8"){

        @Override
        void write(ExpositionFormats expositionFormats, OutputStream outputStream, MetricSnapshots snapshots) throws IOException {
            expositionFormats.getOpenMetricsTextFormatWriter().write(outputStream, snapshots);
        }
    }
    ,
    CONTENT_TYPE_PROTOBUF("application/vnd.google.protobuf; proto=io.prometheus.client.MetricFamily; encoding=delimited"){

        @Override
        void write(ExpositionFormats expositionFormats, OutputStream outputStream, MetricSnapshots snapshots) throws IOException {
            expositionFormats.getPrometheusProtobufWriter().write(outputStream, snapshots);
        }
    };

    private final MimeType mimeType;

    private PrometheusOutputFormat(String mimeType) {
        this.mimeType = MimeTypeUtils.parseMimeType((String)mimeType);
    }

    @Override
    public MimeType getProducedMimeType() {
        return this.mimeType;
    }

    abstract void write(ExpositionFormats var1, OutputStream var2, MetricSnapshots var3) throws IOException;
}

