/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.docker.ssl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.Base64Utils;

final class CertificateParser {
    private static final String HEADER = "-+BEGIN\\s+.*CERTIFICATE[^-]*-+(?:\\s|\\r|\\n)+";
    private static final String BASE64_TEXT = "([a-z0-9+/=\\r\\n]+)";
    private static final String FOOTER = "-+END\\s+.*CERTIFICATE[^-]*-+";
    private static final Pattern PATTERN = Pattern.compile("-+BEGIN\\s+.*CERTIFICATE[^-]*-+(?:\\s|\\r|\\n)+([a-z0-9+/=\\r\\n]+)-+END\\s+.*CERTIFICATE[^-]*-+", 2);

    private CertificateParser() {
    }

    static X509Certificate[] parse(Path ... paths) {
        CertificateFactory factory = CertificateParser.getCertificateFactory();
        ArrayList certificates = new ArrayList();
        for (Path path : paths) {
            CertificateParser.readCertificates(path, factory, certificates::add);
        }
        return certificates.toArray(new X509Certificate[0]);
    }

    private static CertificateFactory getCertificateFactory() {
        try {
            return CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException ex) {
            throw new IllegalStateException("Unable to get X.509 certificate factory", ex);
        }
    }

    private static void readCertificates(Path path, CertificateFactory factory, Consumer<X509Certificate> consumer) {
        try {
            String text = CertificateParser.readText(path);
            Matcher matcher = PATTERN.matcher(text);
            while (matcher.find()) {
                String encodedText = matcher.group(1);
                byte[] decodedBytes = CertificateParser.decodeBase64(encodedText);
                ByteArrayInputStream inputStream = new ByteArrayInputStream(decodedBytes);
                while (inputStream.available() > 0) {
                    consumer.accept((X509Certificate)factory.generateCertificate(inputStream));
                }
            }
        }
        catch (IOException | CertificateException ex) {
            throw new IllegalStateException("Error reading certificate from '" + path + "' : " + ex.getMessage(), ex);
        }
    }

    private static String readText(Path path) throws IOException {
        byte[] bytes = Files.readAllBytes(path);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private static byte[] decodeBase64(String content) {
        byte[] bytes = content.replaceAll("\r", "").replaceAll("\n", "").getBytes();
        return Base64Utils.decode((byte[])bytes);
    }
}

