/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.docker.type;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.boot.buildpack.platform.json.MappedObject;

public class ImageConfig
extends MappedObject {
    private final Map<String, String> labels = this.extractLabels();
    private final Map<String, String> configEnv = this.parseConfigEnv();

    ImageConfig(JsonNode node) {
        super(node, MethodHandles.lookup());
    }

    private Map<String, String> extractLabels() {
        Map labels = this.valueAt("/Labels", Map.class);
        if (labels == null) {
            return Collections.emptyMap();
        }
        return labels;
    }

    private Map<String, String> parseConfigEnv() {
        String[] entries = this.valueAt("/Env", String[].class);
        if (entries == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> env = new LinkedHashMap<String, String>();
        for (String entry : entries) {
            int i = entry.indexOf(61);
            String name = i != -1 ? entry.substring(0, i) : entry;
            String value = i != -1 ? entry.substring(i + 1) : null;
            env.put(name, value);
        }
        return Collections.unmodifiableMap(env);
    }

    JsonNode getNodeCopy() {
        return super.getNode().deepCopy();
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public Map<String, String> getEnv() {
        return this.configEnv;
    }

    public ImageConfig copy(Consumer<Update> update) {
        return new Update(this).run(update);
    }

    public static final class Update {
        private final ObjectNode copy;

        private Update(ImageConfig source) {
            this.copy = (ObjectNode)source.getNode().deepCopy();
        }

        private ImageConfig run(Consumer<Update> update) {
            update.accept(this);
            return new ImageConfig((JsonNode)this.copy);
        }

        public void withLabel(String label, String value) {
            JsonNode labels = this.copy.at("/Labels");
            if (labels.isMissingNode()) {
                labels = this.copy.putObject("Labels");
            }
            ((ObjectNode)labels).put(label, value);
        }
    }
}

