/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.build;

import java.io.PrintStream;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.buildpack.platform.build.BuildRequest;
import org.springframework.boot.buildpack.platform.build.Cache;
import org.springframework.boot.buildpack.platform.build.ImageType;
import org.springframework.boot.buildpack.platform.build.LifecycleVersion;
import org.springframework.boot.buildpack.platform.build.PrintStreamBuildLog;
import org.springframework.boot.buildpack.platform.docker.LogUpdateEvent;
import org.springframework.boot.buildpack.platform.docker.TotalProgressEvent;
import org.springframework.boot.buildpack.platform.docker.type.Binding;
import org.springframework.boot.buildpack.platform.docker.type.Image;
import org.springframework.boot.buildpack.platform.docker.type.ImagePlatform;
import org.springframework.boot.buildpack.platform.docker.type.ImageReference;
import org.springframework.boot.buildpack.platform.docker.type.VolumeName;

public interface BuildLog {
    public void start(BuildRequest var1);

    public Consumer<TotalProgressEvent> pullingImage(ImageReference var1, @Nullable ImagePlatform var2, ImageType var3);

    public void pulledImage(Image var1, ImageType var2);

    public Consumer<TotalProgressEvent> pushingImage(ImageReference var1);

    public void pushedImage(ImageReference var1);

    public void executingLifecycle(BuildRequest var1, LifecycleVersion var2, VolumeName var3);

    public void executingLifecycle(BuildRequest var1, LifecycleVersion var2, Cache var3);

    public Consumer<LogUpdateEvent> runningPhase(BuildRequest var1, String var2);

    public void skippingPhase(String var1, String var2);

    public void executedLifecycle(BuildRequest var1);

    public void taggedImage(ImageReference var1);

    public void failedCleaningWorkDir(Cache var1, @Nullable Exception var2);

    public void sensitiveTargetBindingDetected(Binding var1);

    public static BuildLog toSystemOut() {
        return BuildLog.to(System.out);
    }

    public static BuildLog to(PrintStream out) {
        return new PrintStreamBuildLog(out);
    }
}

