/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.docker.ssl;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.buildpack.platform.docker.ssl.PemCertificateParser;
import org.springframework.boot.buildpack.platform.docker.ssl.PemPrivateKeyParser;

final class KeyStoreFactory {
    private static final char[] NO_PASSWORD = new char[0];

    private KeyStoreFactory() {
    }

    static KeyStore create(Path certPath, @Nullable Path keyPath, String alias) {
        try {
            KeyStore keyStore = KeyStoreFactory.getKeyStore();
            String certificateText = Files.readString(certPath);
            List<X509Certificate> certificates = PemCertificateParser.parse(certificateText);
            PrivateKey privateKey = KeyStoreFactory.getPrivateKey(keyPath);
            try {
                KeyStoreFactory.addCertificates(keyStore, (X509Certificate[])certificates.toArray(X509Certificate[]::new), privateKey, alias);
            }
            catch (KeyStoreException ex) {
                throw new IllegalStateException("Error adding certificates to KeyStore: " + ex.getMessage(), ex);
            }
            return keyStore;
        }
        catch (IOException | GeneralSecurityException ex) {
            throw new IllegalStateException("Error creating KeyStore: " + ex.getMessage(), ex);
        }
    }

    private static KeyStore getKeyStore() throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null);
        return keyStore;
    }

    private static @Nullable PrivateKey getPrivateKey(@Nullable Path path) throws IOException {
        if (path != null && Files.exists(path, new LinkOption[0])) {
            String text = Files.readString(path);
            return PemPrivateKeyParser.parse(text);
        }
        return null;
    }

    private static void addCertificates(KeyStore keyStore, X509Certificate[] certificates, @Nullable PrivateKey privateKey, String alias) throws KeyStoreException {
        if (privateKey != null) {
            keyStore.setKeyEntry(alias, privateKey, NO_PASSWORD, certificates);
        } else {
            for (int index = 0; index < certificates.length; ++index) {
                keyStore.setCertificateEntry(alias + "-" + index, certificates[index]);
            }
        }
    }
}

