/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.configurationprocessor;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Types;

class TypeUtils {
    private static final Map<TypeKind, Class<?>> PRIMITIVE_WRAPPERS;
    private static final Map<String, TypeKind> WRAPPER_TO_PRIMITIVE;
    private final ProcessingEnvironment env;
    private final TypeMirror collectionType;
    private final TypeMirror mapType;

    TypeUtils(ProcessingEnvironment env) {
        this.env = env;
        Types types = env.getTypeUtils();
        WildcardType wc = types.getWildcardType(null, null);
        this.collectionType = types.getDeclaredType(this.env.getElementUtils().getTypeElement(Collection.class.getName()), wc);
        this.mapType = types.getDeclaredType(this.env.getElementUtils().getTypeElement(Map.class.getName()), wc, wc);
    }

    public String getType(Element element) {
        return this.getType(element == null ? null : element.asType());
    }

    public String getType(TypeMirror type) {
        DeclaredType declaredType;
        Element enclosingElement;
        if (type == null) {
            return null;
        }
        Class<?> wrapper = this.getWrapperFor(type);
        if (wrapper != null) {
            return wrapper.getName();
        }
        if (type instanceof DeclaredType && (enclosingElement = (declaredType = (DeclaredType)type).asElement().getEnclosingElement()) != null && enclosingElement instanceof TypeElement) {
            return this.getType(enclosingElement) + "$" + declaredType.asElement().getSimpleName().toString();
        }
        return type.toString();
    }

    public boolean isCollectionOrMap(TypeMirror type) {
        return this.env.getTypeUtils().isAssignable(type, this.collectionType) || this.env.getTypeUtils().isAssignable(type, this.mapType);
    }

    public boolean isEnclosedIn(Element candidate, TypeElement element) {
        if (candidate == null || element == null) {
            return false;
        }
        if (candidate.equals(element)) {
            return true;
        }
        return this.isEnclosedIn(candidate.getEnclosingElement(), element);
    }

    public String getJavaDoc(Element element) {
        String javadoc;
        String string = javadoc = element == null ? null : this.env.getElementUtils().getDocComment(element);
        if (javadoc != null) {
            javadoc = javadoc.trim();
        }
        return "".equals(javadoc) ? null : javadoc;
    }

    public TypeMirror getWrapperOrPrimitiveFor(TypeMirror typeMirror) {
        Class<?> candidate = this.getWrapperFor(typeMirror);
        if (candidate != null) {
            return this.env.getElementUtils().getTypeElement(candidate.getName()).asType();
        }
        TypeKind primitiveKind = this.getPrimitiveFor(typeMirror);
        if (primitiveKind != null) {
            return this.env.getTypeUtils().getPrimitiveType(primitiveKind);
        }
        return null;
    }

    private Class<?> getWrapperFor(TypeMirror type) {
        return PRIMITIVE_WRAPPERS.get((Object)type.getKind());
    }

    private TypeKind getPrimitiveFor(TypeMirror type) {
        return WRAPPER_TO_PRIMITIVE.get(type.toString());
    }

    static {
        HashMap<TypeKind, Class> wrappers = new HashMap<TypeKind, Class>();
        wrappers.put(TypeKind.BOOLEAN, Boolean.class);
        wrappers.put(TypeKind.BYTE, Byte.class);
        wrappers.put(TypeKind.CHAR, Character.class);
        wrappers.put(TypeKind.DOUBLE, Double.class);
        wrappers.put(TypeKind.FLOAT, Float.class);
        wrappers.put(TypeKind.INT, Integer.class);
        wrappers.put(TypeKind.LONG, Long.class);
        wrappers.put(TypeKind.SHORT, Short.class);
        PRIMITIVE_WRAPPERS = Collections.unmodifiableMap(wrappers);
        HashMap<String, TypeKind> primitives = new HashMap<String, TypeKind>();
        for (Map.Entry<TypeKind, Class<?>> entry : PRIMITIVE_WRAPPERS.entrySet()) {
            primitives.put(entry.getValue().getName(), entry.getKey());
        }
        WRAPPER_TO_PRIMITIVE = primitives;
    }
}

