/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.restart;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.boot.devtools.restart.classloader.ClassLoaderFile;
import org.springframework.boot.devtools.restart.classloader.ClassLoaderFileURLStreamHandler;
import org.springframework.boot.devtools.restart.classloader.ClassLoaderFiles;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.AntPathMatcher;

final class ClassLoaderFilesResourcePatternResolver
implements ResourcePatternResolver {
    private static final String[] LOCATION_PATTERN_PREFIXES = new String[]{"classpath*:", "classpath:"};
    private final ResourcePatternResolver delegate = new PathMatchingResourcePatternResolver();
    private final AntPathMatcher antPathMatcher = new AntPathMatcher();
    private final ClassLoaderFiles classLoaderFiles;

    ClassLoaderFilesResourcePatternResolver(ClassLoaderFiles classLoaderFiles) {
        this.classLoaderFiles = classLoaderFiles;
    }

    public ClassLoader getClassLoader() {
        return this.delegate.getClassLoader();
    }

    public Resource getResource(String location) {
        Resource candidate = this.delegate.getResource(location);
        if (this.isDeleted(candidate)) {
            return new DeletedClassLoaderFileResource(location);
        }
        return candidate;
    }

    public Resource[] getResources(String locationPattern) throws IOException {
        Resource[] candidates;
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (Resource candidate : candidates = this.delegate.getResources(locationPattern)) {
            if (this.isDeleted(candidate)) continue;
            resources.add(candidate);
        }
        resources.addAll(this.getAdditionalResources(locationPattern));
        return resources.toArray(new Resource[resources.size()]);
    }

    private List<Resource> getAdditionalResources(String locationPattern) throws MalformedURLException {
        ArrayList<Resource> additionalResources = new ArrayList<Resource>();
        String trimmedLocationPattern = this.trimLocationPattern(locationPattern);
        for (ClassLoaderFiles.SourceFolder sourceFolder : this.classLoaderFiles.getSourceFolders()) {
            for (Map.Entry<String, ClassLoaderFile> entry : sourceFolder.getFilesEntrySet()) {
                String name = entry.getKey();
                ClassLoaderFile file = entry.getValue();
                if (file.getKind() != ClassLoaderFile.Kind.ADDED || !this.antPathMatcher.match(trimmedLocationPattern, name)) continue;
                URL url = new URL("reloaded", null, -1, "/" + name, new ClassLoaderFileURLStreamHandler(file));
                UrlResource resource = new UrlResource(url);
                additionalResources.add((Resource)resource);
            }
        }
        return additionalResources;
    }

    private String trimLocationPattern(String pattern) {
        for (String prefix : LOCATION_PATTERN_PREFIXES) {
            if (!pattern.startsWith(prefix)) continue;
            return pattern.substring(prefix.length());
        }
        return pattern;
    }

    private boolean isDeleted(Resource resource) {
        for (ClassLoaderFiles.SourceFolder sourceFolder : this.classLoaderFiles.getSourceFolders()) {
            for (Map.Entry<String, ClassLoaderFile> entry : sourceFolder.getFilesEntrySet()) {
                try {
                    String name = entry.getKey();
                    ClassLoaderFile file = entry.getValue();
                    if (file.getKind() != ClassLoaderFile.Kind.DELETED || !resource.exists() || !resource.getURI().toString().endsWith(name)) continue;
                    return true;
                }
                catch (IOException ex) {
                    throw new IllegalStateException("Failed to retrieve URI from '" + resource + "'", ex);
                }
            }
        }
        return false;
    }

    private final class DeletedClassLoaderFileResource
    extends AbstractResource {
        private final String name;

        private DeletedClassLoaderFileResource(String name) {
            this.name = name;
        }

        public boolean exists() {
            return false;
        }

        public String getDescription() {
            return "Deleted: " + this.name;
        }

        public InputStream getInputStream() throws IOException {
            throw new IOException(this.name + " has been deleted");
        }
    }
}

