/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.restart;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;

class SilentExitExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private final Thread.UncaughtExceptionHandler delegate;

    SilentExitExceptionHandler(Thread.UncaughtExceptionHandler delegate) {
        this.delegate = delegate;
    }

    @Override
    public void uncaughtException(Thread thread, Throwable exception) {
        if (exception instanceof SilentExitException || exception instanceof InvocationTargetException && ((InvocationTargetException)exception).getTargetException() instanceof SilentExitException) {
            if (this.isJvmExiting(thread)) {
                this.preventNonZeroExitCode();
            }
            return;
        }
        if (this.delegate != null) {
            this.delegate.uncaughtException(thread, exception);
        }
    }

    private boolean isJvmExiting(Thread exceptionThread) {
        for (Thread thread : this.getAllThreads()) {
            if (thread == exceptionThread || !thread.isAlive() || thread.isDaemon()) continue;
            return false;
        }
        return true;
    }

    protected Thread[] getAllThreads() {
        ThreadGroup rootThreadGroup = this.getRootThreadGroup();
        Thread[] threads = new Thread[32];
        int count = rootThreadGroup.enumerate(threads);
        while (count == threads.length) {
            threads = new Thread[threads.length * 2];
            count = rootThreadGroup.enumerate(threads);
        }
        return Arrays.copyOf(threads, count);
    }

    private ThreadGroup getRootThreadGroup() {
        ThreadGroup candidate = Thread.currentThread().getThreadGroup();
        while (candidate.getParent() != null) {
            candidate = candidate.getParent();
        }
        return candidate;
    }

    protected void preventNonZeroExitCode() {
        System.exit(0);
    }

    static void setup(Thread thread) {
        Thread.UncaughtExceptionHandler handler = thread.getUncaughtExceptionHandler();
        if (!(handler instanceof SilentExitExceptionHandler)) {
            handler = new SilentExitExceptionHandler(handler);
            thread.setUncaughtExceptionHandler(handler);
        }
    }

    static void exitCurrentThread() {
        throw new SilentExitException();
    }

    private static class SilentExitException
    extends RuntimeException {
        private SilentExitException() {
        }
    }
}

