/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.docker.compose.service.connection.postgres;

import io.r2dbc.spi.ConnectionFactoryOptions;
import org.springframework.boot.autoconfigure.r2dbc.R2dbcConnectionDetails;
import org.springframework.boot.docker.compose.core.RunningService;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionDetailsFactory;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionSource;
import org.springframework.boot.docker.compose.service.connection.postgres.PostgresEnvironment;
import org.springframework.boot.docker.compose.service.connection.r2dbc.ConnectionFactoryOptionsBuilder;

class PostgresR2dbcDockerComposeConnectionDetailsFactory
extends DockerComposeConnectionDetailsFactory<R2dbcConnectionDetails> {
    PostgresR2dbcDockerComposeConnectionDetailsFactory() {
        super("postgres", "io.r2dbc.spi.ConnectionFactoryOptions");
    }

    @Override
    protected R2dbcConnectionDetails getDockerComposeConnectionDetails(DockerComposeConnectionSource source) {
        return new PostgresDbR2dbcDockerComposeConnectionDetails(source.getRunningService());
    }

    static class PostgresDbR2dbcDockerComposeConnectionDetails
    extends DockerComposeConnectionDetailsFactory.DockerComposeConnectionDetails
    implements R2dbcConnectionDetails {
        private static final ConnectionFactoryOptionsBuilder connectionFactoryOptionsBuilder = new ConnectionFactoryOptionsBuilder("postgresql", 5432);
        private final ConnectionFactoryOptions connectionFactoryOptions;

        PostgresDbR2dbcDockerComposeConnectionDetails(RunningService service) {
            super(service);
            PostgresEnvironment environment = new PostgresEnvironment(service.env());
            this.connectionFactoryOptions = connectionFactoryOptionsBuilder.build(service, environment.getDatabase(), environment.getUsername(), environment.getPassword());
        }

        public ConnectionFactoryOptions getConnectionFactoryOptions() {
            return this.connectionFactoryOptions;
        }
    }
}

